<!DOCTYPE html>
<html lang="{{ systemLanguage() ? systemLanguage()->locale : 'en' }}"
      dir="{{ systemLanguage() ? systemLanguage()->text_direction : 'ltr' }}">
<head>

    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- Primary Meta Tags -->
    @if(setting('meta_title') != '')
        <title>{{setting('meta_title')}}</title>
    @else
        <title>@yield('title',setting('system_name'))</title>
    @endif

    <meta name="title" content="{{ setting('meta_title')}}"/>
    <meta name="description" content="{{ setting('meta_description')}}"/>
    <meta name="keywords" content="{{ setting('meta_keywords')}}"/>
    <meta name="author" content="{{ setting('author_name')}}">
    <meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests">

    <meta name="robots" content="index, follow" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta name="theme-color" content="#0078d7" />

    <!-- Open Graph / Facebook -->
    <meta property="og:title" content="{{ setting('og_title')}}" />
    <meta property="og:description" content="{{ setting('meta_description')}}" />
    <meta property="og:url" content="{{ url('/')}}" />
    <meta property="og:type" content="website" />
    <meta property="og:image" content="{{ getFileLink('original_image',setting('og_image')) }}" />
    <meta property="og:site_name" content="{{ setting('system_name') }}" />
    <meta property="og:locale" content="{{ app()->getLocale() }}" />
    <meta property="og:image:width" content="1200" />
    <meta property="og:image:height" content="630" />

    <!-- Twitter -->
    <meta name="twitter:card" content="summary_large_image" />
    <meta name="twitter:site" content="{{ setting('system_name') }}" />
    <meta name="twitter:creator" content="{{ setting('author_name')}}" />
    <meta name="twitter:title" content="{{ setting('meta_title')}}" />
    <meta name="twitter:description" content="{{ setting('meta_description')}}" />
    <meta name="twitter:image" content="{{ getFileLink('original_image',setting('og_image')) }}" />

    <!-- Additional SEO Meta Tags -->
    <link rel="canonical" href="https://salemag.net/" />
    <meta name="distribution" content="global" />
    <meta name="rating" content="general" />
    <meta name="revisit-after" content="7 days" />

    <!-- Structured Data (JSON-LD) -->
    <script type="application/ld+json">
        {
          "@context": "https://schema.org",
          "@type": "SoftwareApplication",
          "name": "SaleMag",
          "url": "https://salemag.net/",
          "description": "Boost your sales with SaleMag, the ultimate platform for cold outreach and marketing automation on WhatsApp and Telegram.",
          "applicationCategory": "MarketingApplication",
          "operatingSystem": "Web",
          "image": "{{ getFileLink('original_image',setting('og_image')) }}",
          "offers": {
            "@type": "Offer",
            "priceCurrency": "USD",
            "price": "9.99",
            "availability": "https://schema.org/InStock"
          }
        }
    </script>

    <!-- SEO -->
    @if(setting('meta_title') != '')
        {{-- <title>{{setting('meta_title')}}</title> --}}
        @if(setting('meta_title') != '')
        <title>{{setting('meta_title')}}</title>
    @else
        <title>@yield('title',setting('system_name'))</title>
    @endif

    @else
        <title>@yield('title',setting('system_name'))</title>
    @endif
    @php
        $icon = setting('favicon');
    @endphp
    @if ($icon)
        <link rel="apple-touch-icon" sizes="57x57"
              href="{{ $icon != [] && @is_file_exists($icon['image_57x57_url']) ? static_asset($icon['image_57x57_url']) : static_asset('images/default/favicon/favicon-57x57.png') }}">
        <link rel="apple-touch-icon" sizes="60x60"
              href="{{ $icon != [] && @is_file_exists($icon['image_60x60_url']) ? static_asset($icon['image_60x60_url']) : static_asset('images/default/favicon/favicon-60x60.png') }}">
        <link rel="apple-touch-icon" sizes="72x72"
              href="{{ $icon != [] && @is_file_exists($icon['image_72x72_url']) ? static_asset($icon['image_72x72_url']) : static_asset('images/default/favicon/favicon-72x72.png') }}">
        <link rel="apple-touch-icon" sizes="76x76"
              href="{{ $icon != [] && @is_file_exists($icon['image_76x76_url']) ? static_asset($icon['image_76x76_url']) : static_asset('images/default/favicon/favicon-76x76.png') }}">
        <link rel="apple-touch-icon" sizes="114x114"
              href="{{ $icon != [] && @is_file_exists($icon['image_114x114_url']) ? static_asset($icon['image_114x114_url']) : static_asset('images/default/favicon/favicon-114x114.png') }}">
        <link rel="apple-touch-icon" sizes="120x120"
              href="{{ $icon != [] && @is_file_exists($icon['image_120x120_url']) ? static_asset($icon['image_120x120_url']) : static_asset('images/default/favicon/favicon-120x120.png') }}">
        <link rel="apple-touch-icon" sizes="144x144"
              href="{{ $icon != [] && @is_file_exists($icon['image_144x144_url']) ? static_asset($icon['image_144x144_url']) : static_asset('images/default/favicon/favicon-144x144.png') }}">
        <link rel="apple-touch-icon" sizes="152x152"
              href="{{ $icon != [] && @is_file_exists($icon['image_152x152_url']) ? static_asset($icon['image_152x152_url']) : static_asset('images/default/favicon/favicon-152x152.png') }}">
        <link rel="apple-touch-icon" sizes="180x180"
              href="{{ $icon != [] && @is_file_exists($icon['image_180x180_url']) ? static_asset($icon['image_180x180_url']) : static_asset('images/default/favicon/favicon-180x180.png') }}">
        <link rel="icon" type="image/png" sizes="192x192"
              href="{{ $icon != [] && @is_file_exists($icon['image_192x192_url']) ? static_asset($icon['image_192x192_url']) : static_asset('images/favicon-192x192.png') }}">
        <link rel="icon" type="image/png" sizes="32x32"
              href="{{ $icon != [] && @is_file_exists($icon['image_32x32_url']) ? static_asset($icon['image_32x32_url']) : static_asset('images/default/favicon/favicon-32x32.png') }}">
        <link rel="icon" type="image/png" sizes="96x96"
              href="{{ $icon != [] && @is_file_exists($icon['image_96x96_url']) ? static_asset($icon['image_96x96_url']) : static_asset('images/default/favicon/favicon-96x96.png') }}">
        <link rel="icon" type="image/png" sizes="16x16"
              href="{{ $icon != [] && @is_file_exists($icon['image_16x16_url']) ? static_asset($icon['image_16x16_url']) : static_asset('images/default/favicon/favicon-16x16.png') }}">
        <link rel="manifest" href="{{ static_asset('images/default/favicon/manifest.json') }}">

        <meta name="msapplication-TileColor" content="#ffffff">
        <meta name="msapplication-TileImage"
              content="{{ $icon != [] && @is_file_exists($icon['image_144x144_url']) ? static_asset($icon['image_144x144_url']) : static_asset('images/default/favicon/favicon-144x144.png') }}">
    @else
        <link rel="shortcut icon" href="{{ static_asset('images/default/favicon/favicon-96x96.png') }}">
    @endif

    <style>
        @if (base64_decode(setting('custom_css')))
            {{ base64_decode(setting('custom_css')) }}
        @endif
    </style>

    @if (setting('is_google_analytics_activated') && setting('tracking_code'))
        {!! base64_decode(setting('tracking_code')) !!}
    @endif

    @if (setting('custom_header_script'))
        {!! base64_decode(setting('custom_header_script')) !!}
    @endif
    @if (setting('is_facebook_pixel_activated') && setting('facebook_pixel_id'))
        {!! base64_decode(setting('facebook_pixel_id')) !!}
    @endif

    <!-- Remix Icon -->
    <link rel="stylesheet" href="{{ static_asset('website/themes/salemag/assets/css/remixicon.css')}}" />
    <!-- bootstraph -->
    <link rel="stylesheet" href="{{ static_asset('website/themes/salemag/assets/css/bootstrap.min.css')}}" />
    <!-- Swiper Slider -->
    <link rel="stylesheet" href="{{ static_asset('website/themes/salemag/assets/css/swiper-bundle.min.css')}}" />
    <!-- Aos Animation -->
    <link rel="stylesheet" href="{{ static_asset('website/themes/salemag/assets/css/aos.css')}}" />
    <!-- Accordion -->
    <link rel="stylesheet" href="{{ static_asset('website/themes/salemag/assets/css/accordion.css')}}" />
    <!-- User's CSS Here -->
    <link rel="stylesheet" href="{{ static_asset('website/themes/salemag/assets/css/style.css')}}" />
</head>
<body>
<!-- Preloader Start -->
{{--<div id="preloader">--}}
{{--    <div id="salemag__preloader" class="preloader">--}}
{{--        <div class="animation__preloader">--}}
{{--            <div class="box">--}}
{{--                <img src="{{ static_asset('website/themes/salemag/assets/images/logo/favicon.svg')}}" alt="favicon" />--}}
{{--                <div class="spinner"></div>--}}
{{--            </div>--}}
{{--            <div class="txt__loading">--}}
{{--                <span data-text-preloader="S" class="letters__loading">S</span>--}}
{{--                <span data-text-preloader="A" class="letters__loading">A</span>--}}
{{--                <span data-text-preloader="L" class="letters__loading">L</span>--}}
{{--                <span data-text-preloader="E" class="letters__loading">E</span>--}}
{{--                <span data-text-preloader="M" class="letters__loading">M</span>--}}
{{--                <span data-text-preloader="A" class="letters__loading">A</span>--}}
{{--                <span data-text-preloader="G" class="letters__loading">G</span>--}}
{{--            </div>--}}
{{--        </div>--}}
{{--        <div class="loader__section section_left"></div>--}}
{{--        <div class="loader__section section_right"></div>--}}
{{--    </div>--}}
{{--</div>--}}
<!-- Preloader End -->


@include('website.themes.modern.layouts.header')
@yield('content')
@include('website.themes.modern.layouts.footer')

<!-- Header Flyout Menu Start -->
<div class="flyoutMenu">
    <div class="flyout__flip">
        <div class="flyout__inner">
            <div class="menu__header-top">
                @php
                    $src = setting('light_logo') && @is_file_exists(setting('light_logo')['original_image']) ? get_media(setting('light_logo')['original_image']) : get_media('images/default/logo/logo-green-white.png');
                @endphp
                <div class="brand__logo">
                    <a href="{{url('/')}}"><img src="{{ $src }}" alt="logo" /> </a>
                </div>
                <!-- Close -->
                <div class="closest__btn">
                    <i class="ri-close-large-fill"></i>
                </div>
                <!-- Close -->
            </div>
            <div class="flyout__menu">
                <ul class="flyout-main__menu">
                    <li class="has__dropdown">
                        <a href="#" class="nav__link">SaleMag</a>
                        <div class="sub__menu">
                            <a href="#" class="menu__item">
                                <div class="icon">
                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_705_1108)">
                                            <path
                                                    d="M1.56594 14.8984C0.84192 15.8981 0.322273 17.0308 0.0367782 18.2317C-0.0177567 18.4708 -0.0107298 18.7198 0.0572011 18.9554C0.125132 19.1911 0.251745 19.4056 0.425186 19.579C0.598626 19.7523 0.813222 19.8788 1.04888 19.9466C1.28454 20.0145 1.53356 20.0214 1.77261 19.9667C2.97165 19.6808 4.10262 19.1614 5.10094 18.4384C5.57038 17.9696 5.83437 17.3336 5.83484 16.6701C5.8353 16.0067 5.57222 15.3703 5.10345 14.9009C4.63468 14.4314 3.99862 14.1675 3.33521 14.167C2.6718 14.1665 2.03538 14.4296 1.56594 14.8984ZM3.92261 17.2559C3.25095 17.6861 2.52139 18.0183 1.75595 18.2425C1.98051 17.4772 2.31272 16.7477 2.74261 16.0759C2.89978 15.9241 3.11028 15.8401 3.32878 15.842C3.54728 15.8439 3.75629 15.9315 3.91079 16.086C4.0653 16.2405 4.15294 16.4495 4.15484 16.668C4.15674 16.8865 4.07274 17.097 3.92094 17.2542L3.92261 17.2559ZM15.0001 7.08338C15.0001 7.63591 14.7806 8.16582 14.3899 8.55652C13.9992 8.94722 13.4693 9.16671 12.9168 9.16671C12.3642 9.16671 11.8343 8.94722 11.4436 8.55652C11.0529 8.16582 10.8334 7.63591 10.8334 7.08338C10.8334 6.53084 11.0529 6.00094 11.4436 5.61024C11.8343 5.21954 12.3642 5.00005 12.9168 5.00005C13.4693 5.00005 13.9992 5.21954 14.3899 5.61024C14.7806 6.00094 15.0001 6.53084 15.0001 7.08338ZM17.4768 4.49579e-05C15.4937 -0.0117439 13.5345 0.433651 11.7514 1.30165C9.96825 2.16965 8.40915 3.43691 7.19511 5.00505C5.87106 5.05082 4.57242 5.38138 3.38761 5.97421C2.01363 6.6069 0.891979 7.68277 0.202612 9.02921C0.040836 9.40485 -0.0248302 9.81487 0.0115423 10.2222C0.0479148 10.6296 0.185181 11.0215 0.410945 11.3625C0.638864 11.7119 0.950351 11.9989 1.31719 12.1976C1.68402 12.3962 2.09462 12.5002 2.51178 12.5H4.58345C5.35585 12.5038 6.09555 12.8123 6.64172 13.3584C7.1879 13.9046 7.49639 14.6443 7.50011 15.4167V17.4884C7.49982 17.9054 7.60353 18.3159 7.80186 18.6827C8.00018 19.0495 8.28686 19.3611 8.63595 19.5892C8.97698 19.815 9.36888 19.9522 9.77625 19.9886C10.1836 20.025 10.5936 19.9593 10.9693 19.7975C12.3157 19.1082 13.3916 17.9865 14.0243 16.6125C14.6171 15.4277 14.9477 14.1291 14.9934 12.805C16.5641 11.5879 17.8329 10.025 18.7012 8.23772C19.5695 6.45046 20.014 4.48703 20.0001 2.50005C19.9991 2.17005 19.933 1.8435 19.8056 1.5391C19.6781 1.23471 19.4919 0.958464 19.2574 0.726208C19.023 0.493952 18.7451 0.310252 18.4395 0.185641C18.1339 0.0610307 17.8068 -0.00204022 17.4768 4.49579e-05ZM3.62178 10.8334H2.51178C2.37086 10.8345 2.23197 10.7998 2.10809 10.7326C1.98421 10.6654 1.8794 10.5679 1.80344 10.4492C1.72883 10.339 1.68322 10.2117 1.67084 10.0791C1.65846 9.94657 1.67971 9.81304 1.73261 9.69088C2.26957 8.70681 3.11315 7.92497 4.13511 7.46421C4.66314 7.19946 5.22062 6.99806 5.79595 6.86421C4.96764 8.12784 4.24065 9.45503 3.62178 10.8334ZM12.5384 15.865C12.0777 16.8867 11.2962 17.7302 10.3126 18.2675C10.1903 18.3205 10.0566 18.3418 9.92395 18.3294C9.79125 18.317 9.66382 18.2714 9.55344 18.1967C9.43474 18.1208 9.33724 18.0159 9.27005 17.8921C9.20287 17.7682 9.1682 17.6293 9.16928 17.4884V16.3784C10.5476 15.7595 11.8748 15.0325 13.1384 14.2042C13.0038 14.7796 12.8016 15.3371 12.5359 15.865H12.5384ZM12.6509 12.515C11.5233 13.2983 10.3328 13.987 9.09178 14.5742C8.92231 13.6643 8.48132 12.827 7.82683 12.1725C7.17235 11.518 6.33505 11.077 5.42511 10.9075C6.01277 9.6676 6.70177 8.47829 7.48511 7.35171C10.2918 3.43671 13.2001 1.78921 17.5001 1.66671C17.7171 1.66663 17.9256 1.75121 18.0813 1.90248C18.2369 2.05375 18.3274 2.25977 18.3334 2.47671C18.2109 6.80005 16.5634 9.70838 12.6484 12.515H12.6509Z"
                                                    fill="#007F61"
                                            />
                                        </g>
                                    </svg>
                                </div>
                                <div class="content">
                                    <h4 class="title">Features</h4>
                                    <p class="desc">All the features you need to grow</p>
                                </div>
                            </a>
                            <a href="#" class="menu__item">
                                <div class="icon">
                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_705_1222)">
                                            <path
                                                    d="M10 0C8.02219 0 6.08879 0.58649 4.4443 1.6853C2.79981 2.78412 1.51809 4.3459 0.761209 6.17317C0.00433286 8.00043 -0.193701 10.0111 0.192152 11.9509C0.578004 13.8907 1.53041 15.6725 2.92894 17.0711C4.32746 18.4696 6.10929 19.422 8.0491 19.8079C9.98891 20.1937 11.9996 19.9957 13.8268 19.2388C15.6541 18.4819 17.2159 17.2002 18.3147 15.5557C19.4135 13.9112 20 11.9778 20 10C19.9971 7.34872 18.9426 4.80684 17.0679 2.9321C15.1932 1.05736 12.6513 0.00286757 10 0ZM10 18.3333C8.35183 18.3333 6.74066 17.8446 5.37025 16.9289C3.99984 16.0132 2.93174 14.7117 2.30101 13.189C1.67028 11.6663 1.50525 9.99076 1.82679 8.37425C2.14834 6.75774 2.94201 5.27288 4.10745 4.10744C5.27289 2.94201 6.75774 2.14833 8.37425 1.82679C9.99076 1.50525 11.6663 1.67027 13.189 2.301C14.7118 2.93173 16.0132 3.99984 16.9289 5.37025C17.8446 6.74066 18.3333 8.35182 18.3333 10C18.3309 12.2094 17.4522 14.3276 15.8899 15.8899C14.3276 17.4522 12.2094 18.3309 10 18.3333Z"
                                                    fill="#007F61"
                                            />
                                            <path
                                                    d="M10.5973 4.21918C10.1168 4.13162 9.62285 4.15075 9.1505 4.27521C8.67815 4.39968 8.23893 4.62643 7.86392 4.93943C7.4889 5.25243 7.18726 5.64403 6.98035 6.08651C6.77343 6.52899 6.66629 7.01154 6.6665 7.50001C6.6665 7.72103 6.7543 7.93299 6.91058 8.08927C7.06686 8.24555 7.27882 8.33335 7.49984 8.33335C7.72085 8.33335 7.93281 8.24555 8.08909 8.08927C8.24537 7.93299 8.33317 7.72103 8.33317 7.50001C8.33296 7.25483 8.38685 7.01261 8.491 6.79064C8.59514 6.56868 8.74698 6.37242 8.93569 6.21587C9.12439 6.05932 9.34531 5.94633 9.58269 5.88497C9.82007 5.8236 10.0681 5.81536 10.309 5.86085C10.6382 5.92475 10.9409 6.08533 11.1784 6.32209C11.4159 6.55884 11.5774 6.86102 11.6423 7.19001C11.7079 7.53535 11.6626 7.89258 11.513 8.21063C11.3633 8.52868 11.1169 8.79127 10.809 8.96085C10.2991 9.25623 9.87783 9.68294 9.58894 10.1965C9.30006 10.7101 9.15418 11.2917 9.1665 11.8808V12.5C9.1665 12.721 9.2543 12.933 9.41058 13.0893C9.56686 13.2456 9.77882 13.3333 9.99984 13.3333C10.2209 13.3333 10.4328 13.2456 10.5891 13.0893C10.7454 12.933 10.8332 12.721 10.8332 12.5V11.8808C10.8227 11.5909 10.8888 11.3032 11.0249 11.0469C11.1609 10.7906 11.3621 10.5747 11.6082 10.4208C12.2119 10.0892 12.6981 9.57873 12.9999 8.95952C13.3017 8.34031 13.4042 7.64281 13.2934 6.96295C13.1826 6.28309 12.8639 5.65426 12.3811 5.16293C11.8983 4.67159 11.2752 4.3419 10.5973 4.21918Z"
                                                    fill="#007F61"
                                            />
                                            <path
                                                    d="M10.8332 15C10.8332 14.5398 10.4601 14.1667 9.99984 14.1667C9.5396 14.1667 9.1665 14.5398 9.1665 15C9.1665 15.4602 9.5396 15.8333 9.99984 15.8333C10.4601 15.8333 10.8332 15.4602 10.8332 15Z"
                                                    fill="#007F61"
                                            />
                                        </g>
                                    </svg>
                                </div>
                                <div class="content">
                                    <h4 class="title">FAQ</h4>
                                    <p class="desc">Frequently Asked Questions</p>
                                </div>
                            </a>
                            <a href="#" class="menu__item">
                                <div class="icon">
                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_705_1202)">
                                            <path
                                                    d="M14.1665 11.6667C14.1665 11.8877 14.0787 12.0996 13.9224 12.2559C13.7661 12.4122 13.5542 12.5 13.3332 12.5H6.6665C6.44549 12.5 6.23353 12.4122 6.07725 12.2559C5.92097 12.0996 5.83317 11.8877 5.83317 11.6667C5.83317 11.4456 5.92097 11.2337 6.07725 11.0774C6.23353 10.9211 6.44549 10.8333 6.6665 10.8333H13.3332C13.5542 10.8333 13.7661 10.9211 13.9224 11.0774C14.0787 11.2337 14.1665 11.4456 14.1665 11.6667ZM10.8332 14.1667H6.6665C6.44549 14.1667 6.23353 14.2545 6.07725 14.4107C5.92097 14.567 5.83317 14.779 5.83317 15C5.83317 15.221 5.92097 15.433 6.07725 15.5892C6.23353 15.7455 6.44549 15.8333 6.6665 15.8333H10.8332C11.0542 15.8333 11.2661 15.7455 11.4224 15.5892C11.5787 15.433 11.6665 15.221 11.6665 15C11.6665 14.779 11.5787 14.567 11.4224 14.4107C11.2661 14.2545 11.0542 14.1667 10.8332 14.1667ZM18.3332 8.73749V15.8333C18.3318 16.938 17.8924 17.997 17.1113 18.7781C16.3302 19.5593 15.2712 19.9987 14.1665 20H5.83317C4.72851 19.9987 3.66947 19.5593 2.88835 18.7781C2.10724 17.997 1.66783 16.938 1.6665 15.8333V4.16666C1.66783 3.06199 2.10724 2.00295 2.88835 1.22184C3.66947 0.440724 4.72851 0.0013119 5.83317 -1.13103e-05H9.59567C10.362 -0.00198375 11.1212 0.147978 11.8292 0.441205C12.5372 0.734431 13.1801 1.1651 13.7207 1.70832L16.624 4.61332C17.1675 5.15352 17.5985 5.7962 17.8919 6.50413C18.1852 7.21206 18.3352 7.97117 18.3332 8.73749ZM12.5423 2.88666C12.2801 2.63262 11.9856 2.41409 11.6665 2.23666V5.83332C11.6665 6.05434 11.7543 6.2663 11.9106 6.42258C12.0669 6.57886 12.2788 6.66666 12.4998 6.66666H16.0965C15.919 6.34765 15.7001 6.05344 15.4457 5.79166L12.5423 2.88666ZM16.6665 8.73749C16.6665 8.59999 16.6398 8.46832 16.6273 8.33332H12.4998C11.8368 8.33332 11.2009 8.06993 10.7321 7.60109C10.2632 7.13225 9.99984 6.49636 9.99984 5.83332V1.70582C9.86484 1.69332 9.73234 1.66666 9.59567 1.66666H5.83317C5.17013 1.66666 4.53424 1.93005 4.0654 2.39889C3.59656 2.86773 3.33317 3.50361 3.33317 4.16666V15.8333C3.33317 16.4964 3.59656 17.1322 4.0654 17.6011C4.53424 18.0699 5.17013 18.3333 5.83317 18.3333H14.1665C14.8295 18.3333 15.4654 18.0699 15.9343 17.6011C16.4031 17.1322 16.6665 16.4964 16.6665 15.8333V8.73749Z"
                                                    fill="white"
                                            />
                                        </g>
                                    </svg>
                                </div>
                                <div class="content">
                                    <h4 class="title">Documentations</h4>
                                    <p class="desc">Get started with SaleMag</p>
                                </div>
                            </a>
                            <a href="#" class="menu__item">
                                <div class="icon">
                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_705_1229)">
                                            <path
                                                    d="M15.8333 1.66666H4.16667C1.86667 1.66666 0 3.53332 0 5.83332V14.1667C0 16.4667 1.86667 18.3333 4.16667 18.3333H15.8333C18.1333 18.3333 20 16.4667 20 14.1667V5.83332C20 3.53332 18.1333 1.66666 15.8333 1.66666ZM4.16667 3.33332H15.8333C17.2083 3.33332 18.3333 4.45832 18.3333 5.83332H1.66667C1.66667 4.45832 2.79167 3.33332 4.16667 3.33332ZM15.8333 16.6667H4.16667C2.79167 16.6667 1.66667 15.5417 1.66667 14.1667V7.49999H18.3333V14.1667C18.3333 15.5417 17.2083 16.6667 15.8333 16.6667ZM8.33333 9.99999C8.33333 10.4583 7.95833 10.8333 7.5 10.8333H6.66667V14.1667C6.66667 14.625 6.29167 15 5.83333 15C5.375 15 5 14.625 5 14.1667V10.8333H4.16667C3.70833 10.8333 3.33333 10.4583 3.33333 9.99999C3.33333 9.54166 3.70833 9.16666 4.16667 9.16666H7.5C7.95833 9.16666 8.33333 9.54166 8.33333 9.99999ZM16.6667 9.99999C16.6667 10.4583 16.2917 10.8333 15.8333 10.8333H10.8333C10.375 10.8333 10 10.4583 10 9.99999C10 9.54166 10.375 9.16666 10.8333 9.16666H15.8333C16.2917 9.16666 16.6667 9.54166 16.6667 9.99999ZM16.6667 13.3333C16.6667 13.7917 16.2917 14.1667 15.8333 14.1667H10.8333C10.375 14.1667 10 13.7917 10 13.3333C10 12.875 10.375 12.5 10.8333 12.5H15.8333C16.2917 12.5 16.6667 12.875 16.6667 13.3333Z"
                                                    fill="#007F61"
                                            />
                                        </g>
                                    </svg>
                                </div>
                                <div class="content">
                                    <h4 class="title">Blogs</h4>
                                    <p class="desc">All the features you need to grow</p>
                                </div>
                            </a>
                            <a href="#" class="menu__item">
                                <div class="icon">
                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_705_1207)">
                                            <path
                                                    d="M8.52844 8.55567C9.33927 9.34984 10.6609 9.349 11.4709 8.55567C12.6926 7.41484 14.2901 6.009 14.1659 4.1665C14.2126 1.9265 12.2384 -0.0459962 9.99927 -0.000162858C7.7601 -0.0459962 5.78594 1.9265 5.8326 4.1665C5.70594 5.99567 7.3076 7.41817 8.5276 8.55567H8.52844ZM8.2326 2.399C8.70427 1.9265 9.3326 1.6665 10.0001 1.6665C11.3434 1.639 12.5276 2.82234 12.5001 4.1665C12.6209 5.47234 11.0901 6.54234 10.3059 7.364C10.1368 7.529 9.86344 7.529 9.69427 7.364C8.90677 6.53984 7.38177 5.46734 7.5001 4.1665C7.5001 3.49817 7.7601 2.87067 8.2326 2.399ZM8.7501 4.1665C8.7501 3.4765 9.3101 2.9165 10.0001 2.9165C10.6901 2.9165 11.2501 3.4765 11.2501 4.1665C11.2501 4.8565 10.6901 5.4165 10.0001 5.4165C9.3101 5.4165 8.7501 4.8565 8.7501 4.1665ZM10.0001 10.8332C10.4609 10.8332 10.8334 11.2057 10.8334 11.6665V13.3332C10.8334 13.794 10.4609 14.1665 10.0001 14.1665C9.53927 14.1665 9.16677 13.794 9.16677 13.3332V11.6665C9.16677 11.2057 9.53927 10.8332 10.0001 10.8332ZM19.0234 18.5123C18.2301 19.4582 17.0668 19.9998 15.8326 19.9998H4.1676C2.93427 19.9998 1.77177 19.4582 0.978437 18.514C0.18427 17.569 -0.149896 16.3307 0.0626037 15.1157L1.2301 8.44817C1.48344 6.999 2.4976 5.77817 3.8751 5.26317C4.30927 5.1015 4.78677 5.32067 4.9476 5.7515C5.10844 6.18234 4.8901 6.66234 4.45927 6.824C3.6326 7.13317 3.02344 7.86567 2.8726 8.73484L1.70594 15.4023C1.57844 16.1307 1.77844 16.8748 2.25427 17.4407C2.73094 18.0082 3.42844 18.3323 4.16844 18.3323H9.1676V16.6657C9.1676 16.2048 9.5401 15.8323 10.0009 15.8323C10.4618 15.8323 10.8343 16.2048 10.8343 16.6657V18.3323H15.8334C16.5743 18.3323 17.2726 18.0065 17.7484 17.4398C18.2243 16.8732 18.4243 16.129 18.2951 15.399L17.1226 8.73317C16.9701 7.8665 16.3643 7.13567 15.5409 6.82567C15.1101 6.66317 14.8926 6.18317 15.0551 5.75234C15.2168 5.32067 15.6976 5.10484 16.1284 5.26567C17.5001 5.78234 18.5101 7.00067 18.7651 8.444L19.9376 15.1107C20.1509 16.3265 19.8184 17.5657 19.0243 18.5115L19.0234 18.5123Z"
                                                    fill="#007F61"
                                            />
                                        </g>
                                    </svg>
                                </div>
                                <div class="content">
                                    <h4 class="title">Roadmaps</h4>
                                    <p class="desc">Check your upcoming features</p>
                                </div>
                            </a>
                            <a href="#" class="menu__item">
                                <div class="icon">
                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_705_1235)">
                                            <path
                                                    d="M10 1.66667C11.1054 1.67029 12.1992 1.89312 13.2179 2.32224C14.2366 2.75136 15.1602 3.37827 15.935 4.16667H13.3333C13.1123 4.16667 12.9004 4.25447 12.7441 4.41075C12.5878 4.56703 12.5 4.77899 12.5 5C12.5 5.22101 12.5878 5.43298 12.7441 5.58926C12.9004 5.74554 13.1123 5.83333 13.3333 5.83333H16.7858C17.1962 5.83311 17.5897 5.67 17.8798 5.37984C18.17 5.08967 18.3331 4.69619 18.3333 4.28583V0.833334C18.3333 0.612321 18.2455 0.400359 18.0893 0.244079C17.933 0.0877985 17.721 1.08837e-06 17.5 1.08837e-06C17.279 1.08837e-06 17.067 0.0877985 16.9107 0.244079C16.7545 0.400359 16.6667 0.612321 16.6667 0.833334V2.565C15.2893 1.32455 13.5938 0.492009 11.7701 0.160625C9.94635 -0.170759 8.06636 0.0120944 6.34066 0.688707C4.61496 1.36532 3.11169 2.50898 1.99918 3.9916C0.886679 5.47423 0.208874 7.23729 0.0416727 9.08333C0.0309088 9.19938 0.0444358 9.3164 0.0813918 9.42693C0.118348 9.53746 0.177922 9.63909 0.25632 9.72532C0.334717 9.81156 0.430218 9.88052 0.536738 9.92781C0.643258 9.9751 0.75846 9.99969 0.875006 10C1.07883 10.0026 1.27628 9.92903 1.42872 9.79371C1.58116 9.65838 1.6776 9.47103 1.69917 9.26833C1.88468 7.19396 2.83915 5.26392 4.37507 3.85737C5.911 2.45081 7.91735 1.66941 10 1.66667Z"
                                                    fill="#007F61"
                                            />
                                            <path
                                                    d="M19.1257 10C18.9218 9.99741 18.7244 10.071 18.572 10.2063C18.4195 10.3416 18.3231 10.529 18.3015 10.7317C18.1637 12.3177 17.5739 13.8309 16.602 15.0918C15.6302 16.3528 14.317 17.3084 12.8183 17.8455C11.3196 18.3825 9.69833 18.4784 8.1468 18.1218C6.59526 17.7651 5.17858 16.9709 4.06484 15.8333H6.6665C6.88752 15.8333 7.09948 15.7455 7.25576 15.5893C7.41204 15.433 7.49984 15.221 7.49984 15C7.49984 14.779 7.41204 14.567 7.25576 14.4107C7.09948 14.2545 6.88752 14.1667 6.6665 14.1667H3.214C3.01075 14.1666 2.80947 14.2065 2.62167 14.2842C2.43387 14.362 2.26323 14.476 2.11951 14.6197C1.97579 14.7634 1.86181 14.934 1.78408 15.1218C1.70635 15.3096 1.66639 15.5109 1.6665 15.7142V19.1667C1.6665 19.3877 1.7543 19.5996 1.91058 19.7559C2.06686 19.9122 2.27882 20 2.49984 20C2.72085 20 2.93281 19.9122 3.08909 19.7559C3.24537 19.5996 3.33317 19.3877 3.33317 19.1667V17.435C4.71053 18.6755 6.40601 19.508 8.22976 19.8394C10.0535 20.1708 11.9335 19.9879 13.6592 19.3113C15.3849 18.6347 16.8882 17.491 18.0007 16.0084C19.1132 14.5258 19.791 12.7627 19.9582 10.9167C19.9689 10.8006 19.9554 10.6836 19.9184 10.5731C19.8815 10.4625 19.8219 10.3609 19.7435 10.2747C19.6651 10.1884 19.5696 10.1195 19.4631 10.0722C19.3566 10.0249 19.2422 10.0003 19.1257 10Z"
                                                    fill="#007F61"
                                            />
                                        </g>
                                    </svg>
                                </div>
                                <div class="content">
                                    <h4 class="title">Upcoming Updates</h4>
                                    <p class="desc">Let’s find out future facilities</p>
                                </div>
                            </a>
                            <a href="#" class="menu__item">
                                <div class="icon">
                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_705_1215)">
                                            <path
                                                    d="M2.49991 2.5C2.49991 1.57917 3.24574 0.833333 4.16658 0.833333C5.08741 0.833333 5.83324 1.57917 5.83324 2.5C5.83324 3.42083 5.08741 4.16667 4.16658 4.16667C3.24574 4.16667 2.49991 3.42083 2.49991 2.5ZM9.99991 4.16667C11.1507 4.16667 12.0832 3.23417 12.0832 2.08333C12.0832 0.9325 11.1507 0 9.99991 0C8.84908 0 7.91658 0.9325 7.91658 2.08333C7.91658 3.23417 8.84908 4.16667 9.99991 4.16667ZM15.8332 4.16667C16.7541 4.16667 17.4999 3.42083 17.4999 2.5C17.4999 1.57917 16.7541 0.833333 15.8332 0.833333C14.9124 0.833333 14.1666 1.57917 14.1666 2.5C14.1666 3.42083 14.9124 4.16667 15.8332 4.16667ZM10.0007 20C4.79074 20 0.509909 16.0908 0.0424095 10.9083C0.00157614 10.45 0.339076 10.045 0.797409 10.0033C1.26658 9.96333 1.66158 10.3 1.70241 10.7583C1.75658 11.3625 1.87991 11.9433 2.05158 12.5H4.91824C4.78574 11.9867 4.68241 11.4592 4.62908 10.9142C4.58408 10.4558 4.91991 10.0483 5.37741 10.0042C5.83824 9.9625 6.24324 10.295 6.28741 10.7525C6.34574 11.3542 6.47658 11.9375 6.64908 12.5H13.3524C13.5249 11.9375 13.6557 11.3542 13.7141 10.7525C13.7582 10.2942 14.1641 9.96167 14.6241 10.0042C15.0824 10.0483 15.4174 10.4558 15.3724 10.9142C15.3199 11.4592 15.2157 11.9867 15.0832 12.5H17.9499C18.1224 11.9433 18.2449 11.3625 18.2991 10.7583C18.3407 10.3 18.7374 9.96167 19.2041 10.0033C19.6624 10.045 20.0007 10.45 19.9591 10.9083C19.4916 16.0908 15.2107 19.9992 10.0007 20ZM7.31491 14.1667C8.16741 15.8992 9.32241 17.2692 9.99908 17.9883C10.6766 17.2692 11.8307 15.8992 12.6832 14.1667H7.31491ZM7.83741 18.0475C7.05074 17.0733 6.13991 15.74 5.47991 14.1667H2.77658C3.86658 16.0692 5.67658 17.4767 7.83741 18.0475ZM17.2232 14.1667H14.5199C13.8599 15.7408 12.9491 17.0733 12.1624 18.0475C14.3232 17.4767 16.1332 16.0692 17.2232 14.1667ZM7.20741 8.28083C7.63908 8.44167 8.11908 8.225 8.28074 7.7925C8.53324 7.11917 9.22408 6.66667 9.99991 6.66667C10.7757 6.66667 11.4674 7.11917 11.7191 7.7925C11.8799 8.22917 12.3724 8.44 12.7924 8.28083C13.2232 8.11917 13.4416 7.63833 13.2799 7.20833C12.7849 5.8875 11.4666 5.00083 9.99908 5.00083C8.53158 5.00083 7.21324 5.8875 6.71824 7.20833C6.55658 7.63917 6.77491 8.11917 7.20574 8.28083H7.20741ZM15.2932 5.04C14.8382 5.10833 14.5241 5.5325 14.5924 5.98833C14.6607 6.44333 15.0832 6.75083 15.5399 6.68917C16.3824 6.56417 17.2682 7.03333 17.5532 7.7925C17.7141 8.22917 18.2066 8.44 18.6266 8.28083C19.0574 8.11917 19.2757 7.63833 19.1141 7.20833C18.6191 5.8875 17.3007 5.00083 15.8332 5.00083C15.6499 5.00083 15.4691 5.01417 15.2932 5.04ZM1.37408 8.28083C1.79408 8.44083 2.28574 8.22917 2.44741 7.7925C2.73158 7.0325 3.61824 6.56 4.46074 6.68917C4.91574 6.75167 5.33991 6.44333 5.40824 5.98833C5.47658 5.5325 5.16324 5.10833 4.70741 5.04C4.53158 5.01417 4.35074 5 4.16741 5C2.69991 5 1.38158 5.88667 0.886576 7.2075C0.724909 7.63833 0.943243 8.11833 1.37408 8.28V8.28083Z"
                                                    fill="#007F61"
                                            />
                                        </g>
                                    </svg>
                                </div>
                                <div class="content">
                                    <h4 class="title">Community</h4>
                                    <p class="desc">Connect with big network</p>
                                </div>
                            </a>
                        </div>
                    </li>
                    <li class="has__dropdown">
                        <a href="#" class="nav__link">Use Cases</a>
                        <div class="sub__menu">
                            <a href="#" class="menu__item">
                                <div class="icon">
                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_707_2436)">
                                            <path
                                                    d="M20 10C20 15.5167 15.5167 20 10 20C4.48333 20 0 15.5167 0 10C0 4.48333 4.48333 0 10 0C10.6083 0 11.225 0.0583333 11.8167 0.166667C12.2667 0.25 12.5667 0.683333 12.4833 1.13333C12.4 1.58333 11.9667 1.88333 11.5167 1.8C11.025 1.70833 10.5083 1.66667 10 1.66667C5.40833 1.66667 1.66667 5.40833 1.66667 10C1.66667 14.5917 5.40833 18.3333 10 18.3333C14.5917 18.3333 18.3333 14.5917 18.3333 10C18.3333 9.49167 18.2833 8.98333 18.2 8.48333C18.1167 8.03333 18.4167 7.6 18.8667 7.51667C19.325 7.43333 19.75 7.73333 19.8333 8.18333C19.9417 8.775 20 9.39167 20 10ZM10.7167 5.05C11.175 5.11667 11.5917 4.8 11.6583 4.34167C11.725 3.88333 11.4083 3.46667 10.95 3.4C10.6333 3.35833 10.3167 3.33333 10 3.33333C6.325 3.33333 3.33333 6.325 3.33333 10C3.33333 13.675 6.325 16.6667 10 16.6667C13.675 16.6667 16.6667 13.675 16.6667 10C16.6667 9.68333 16.6417 9.36667 16.6 9.05C16.5333 8.59167 16.1167 8.275 15.6583 8.34167C15.2 8.40833 14.8833 8.825 14.95 9.28333C14.9833 9.51667 15 9.75833 15 10C15 12.7583 12.7583 15 10 15C7.24167 15 5 12.7583 5 10C5 7.24167 7.24167 5 10 5C10.2417 5 10.4833 5.01667 10.7167 5.05ZM8.89167 8.75833C9.23333 8.45 9.26667 7.925 8.95833 7.58333C8.65 7.24167 8.125 7.20833 7.78333 7.51667C7.075 8.15 6.675 9.05833 6.675 10C6.675 11.8417 8.16667 13.3333 10.0083 13.3333C10.9583 13.3333 11.8583 12.925 12.4917 12.225C12.8 11.8833 12.7667 11.3583 12.425 11.05C12.0833 10.7417 11.5583 10.775 11.25 11.1167C10.9333 11.4667 10.4833 11.675 10.0083 11.675C9.09167 11.675 8.34167 10.925 8.34167 10.0083C8.34167 9.53333 8.54167 9.08333 8.9 8.76667L8.89167 8.75833ZM10.25 8.575C9.925 8.9 9.925 9.425 10.25 9.75C10.4167 9.91667 10.625 9.99167 10.8417 9.99167C11.0583 9.99167 11.2667 9.90833 11.4333 9.75L15.3583 5.825H17.5167C17.7417 5.825 17.95 5.73333 18.1083 5.58333L19.775 3.91667C20.0167 3.675 20.0833 3.31667 19.9583 3.00833C19.8333 2.7 19.525 2.49167 19.1917 2.49167H17.525V0.833333C17.525 0.5 17.325 0.191667 17.0083 0.0666667C16.6917 -0.0666667 16.3417 0.00833335 16.1 0.25L14.4333 1.91667C14.275 2.075 14.1917 2.28333 14.1917 2.50833V4.66667L10.2667 8.59167L10.25 8.575Z"
                                                    fill="#007F61"
                                            />
                                        </g>
                                    </svg>
                                </div>
                                <div class="content">
                                    <h4 class="title">Retargetting</h4>
                                    <p class="desc">Retarget your existing customers</p>
                                </div>
                            </a>
                            <a href="#" class="menu__item">
                                <div class="icon">
                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_707_2491)">
                                            <path
                                                    d="M10 10C10.9889 10 11.9556 9.70676 12.7779 9.15735C13.6001 8.60794 14.241 7.82705 14.6194 6.91342C14.9978 5.99979 15.0969 4.99446 14.9039 4.02455C14.711 3.05465 14.2348 2.16373 13.5355 1.46447C12.8363 0.765206 11.9454 0.289002 10.9755 0.0960758C10.0055 -0.0968503 9.00021 0.00216643 8.08658 0.380605C7.17295 0.759043 6.39206 1.39991 5.84265 2.22215C5.29324 3.0444 5 4.0111 5 5C5.00132 6.32568 5.52853 7.59668 6.46593 8.53407C7.40332 9.47147 8.67432 9.99868 10 10ZM10 1.66667C10.6593 1.66667 11.3037 1.86217 11.8519 2.22844C12.4001 2.59471 12.8273 3.1153 13.0796 3.72439C13.3319 4.33348 13.3979 5.0037 13.2693 5.6503C13.1407 6.29691 12.8232 6.89085 12.357 7.35703C11.8908 7.8232 11.2969 8.14067 10.6503 8.26929C10.0037 8.3979 9.33348 8.33189 8.72439 8.0796C8.1153 7.82731 7.59471 7.40007 7.22843 6.8519C6.86216 6.30374 6.66667 5.65927 6.66667 5C6.66667 4.11595 7.01786 3.2681 7.64298 2.64298C8.2681 2.01786 9.11594 1.66667 10 1.66667Z"
                                                    fill="#007F61"
                                            />
                                            <path
                                                    d="M10 11.6667C8.01155 11.6689 6.10518 12.4597 4.69914 13.8658C3.29309 15.2718 2.50221 17.1782 2.5 19.1667C2.5 19.3877 2.5878 19.5996 2.74408 19.7559C2.90036 19.9122 3.11232 20 3.33333 20C3.55435 20 3.76631 19.9122 3.92259 19.7559C4.07887 19.5996 4.16667 19.3877 4.16667 19.1667C4.16667 17.6196 4.78125 16.1358 5.87521 15.0419C6.96917 13.9479 8.4529 13.3333 10 13.3333C11.5471 13.3333 13.0308 13.9479 14.1248 15.0419C15.2188 16.1358 15.8333 17.6196 15.8333 19.1667C15.8333 19.3877 15.9211 19.5996 16.0774 19.7559C16.2337 19.9122 16.4457 20 16.6667 20C16.8877 20 17.0996 19.9122 17.2559 19.7559C17.4122 19.5996 17.5 19.3877 17.5 19.1667C17.4978 17.1782 16.7069 15.2718 15.3009 13.8658C13.8948 12.4597 11.9884 11.6689 10 11.6667Z"
                                                    fill="#007F61"
                                            />
                                        </g>
                                    </svg>
                                </div>
                                <div class="content">
                                    <h4 class="title">Founders</h4>
                                    <p class="desc">Reach more people & create awareness</p>
                                </div>
                            </a>
                            <a href="#" class="menu__item">
                                <div class="icon">
                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_707_2441)">
                                            <path
                                                    d="M18.337 3.74832C18.3379 3.02749 17.8995 2.40666 17.2204 2.16666L11.8329 0.265824C10.6762 -0.143342 9.40285 -0.144176 8.24702 0.260824L2.79452 2.16916C2.11285 2.40749 1.67285 3.02749 1.67285 3.74916C1.67285 4.47166 2.11368 5.09166 2.79535 5.32916L5.00035 6.09832V7.49999C5.00035 10.2575 7.24285 12.5 10.0004 12.5C12.7579 12.5 15.0004 10.2575 15.0004 7.49999V6.09832L16.667 5.51666V9.16582C16.667 9.62582 17.0404 9.99916 17.5004 9.99916C17.9604 9.99916 18.3337 9.62582 18.3337 9.16582V3.76832C18.3337 3.76082 18.337 3.75582 18.337 3.74832ZM13.3337 7.49999C13.3337 9.33832 11.8387 10.8333 10.0004 10.8333C8.16202 10.8333 6.66702 9.33832 6.66702 7.49999V6.67999L8.21785 7.22082C8.79202 7.42082 9.39618 7.52166 9.99952 7.52166C10.6029 7.52166 11.2062 7.42082 11.7804 7.22082L13.3337 6.67916V7.49916V7.49999ZM11.232 5.64749C10.4379 5.92499 9.56202 5.92499 8.76785 5.64749L3.34535 3.74166L8.79868 1.83332C9.19702 1.69416 9.61452 1.62416 10.0337 1.62416C10.4554 1.62416 10.877 1.69499 11.2787 1.83666L16.6662 3.75166L11.232 5.64749ZM16.6304 18.9192C16.767 19.3583 16.5212 19.8258 16.082 19.9625C15.9995 19.9883 15.9162 20 15.8345 20C15.4795 20 15.1504 19.7708 15.0387 19.4133C14.3829 17.305 12.312 15.8325 10.0012 15.8325C7.69035 15.8325 5.61952 17.305 4.96368 19.4133C4.82702 19.8533 4.35702 20.0975 3.92035 19.9617C3.48118 19.825 3.23535 19.3575 3.37202 18.9183C4.24202 16.12 6.96785 14.1658 10.0012 14.1658C13.0345 14.1658 15.7604 16.1208 16.6304 18.9192Z"
                                                    fill="#007F61"
                                            />
                                        </g>
                                    </svg>
                                </div>
                                <div class="content">
                                    <h4 class="title">Influencers</h4>
                                    <p class="desc">Build strong community and sale</p>
                                </div>
                            </a>
                            <a href="#" class="menu__item">
                                <div class="icon">
                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_707_2497)">
                                            <path
                                                    d="M17.5 5H15C15 3.67392 14.4732 2.40215 13.5355 1.46447C12.5979 0.526784 11.3261 0 10 0C8.67392 0 7.40215 0.526784 6.46447 1.46447C5.52678 2.40215 5 3.67392 5 5H2.5C1.83696 5 1.20107 5.26339 0.732233 5.73223C0.263392 6.20107 0 6.83696 0 7.5L0 15.8333C0.00132321 16.938 0.440735 17.997 1.22185 18.7782C2.00296 19.5593 3.062 19.9987 4.16667 20H15.8333C16.938 19.9987 17.997 19.5593 18.7782 18.7782C19.5593 17.997 19.9987 16.938 20 15.8333V7.5C20 6.83696 19.7366 6.20107 19.2678 5.73223C18.7989 5.26339 18.163 5 17.5 5ZM10 1.66667C10.8841 1.66667 11.7319 2.01786 12.357 2.64298C12.9821 3.2681 13.3333 4.11594 13.3333 5H6.66667C6.66667 4.11594 7.01786 3.2681 7.64298 2.64298C8.2681 2.01786 9.11594 1.66667 10 1.66667ZM18.3333 15.8333C18.3333 16.4964 18.0699 17.1323 17.6011 17.6011C17.1323 18.0699 16.4964 18.3333 15.8333 18.3333H4.16667C3.50363 18.3333 2.86774 18.0699 2.3989 17.6011C1.93006 17.1323 1.66667 16.4964 1.66667 15.8333V7.5C1.66667 7.27899 1.75446 7.06702 1.91074 6.91074C2.06702 6.75446 2.27899 6.66667 2.5 6.66667H5V8.33333C5 8.55435 5.0878 8.76631 5.24408 8.92259C5.40036 9.07887 5.61232 9.16667 5.83333 9.16667C6.05435 9.16667 6.26631 9.07887 6.42259 8.92259C6.57887 8.76631 6.66667 8.55435 6.66667 8.33333V6.66667H13.3333V8.33333C13.3333 8.55435 13.4211 8.76631 13.5774 8.92259C13.7337 9.07887 13.9457 9.16667 14.1667 9.16667C14.3877 9.16667 14.5996 9.07887 14.7559 8.92259C14.9122 8.76631 15 8.55435 15 8.33333V6.66667H17.5C17.721 6.66667 17.933 6.75446 18.0893 6.91074C18.2455 7.06702 18.3333 7.27899 18.3333 7.5V15.8333Z"
                                                    fill="#007F61"
                                            />
                                        </g>
                                    </svg>
                                </div>
                                <div class="content">
                                    <h4 class="title">Ecommerce stores</h4>
                                    <p class="desc">Scale sales by mass marketing</p>
                                </div>
                            </a>
                            <a href="#" class="menu__item">
                                <div class="icon">
                                    <svg width="20" height="14" viewBox="0 0 20 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path
                                                d="M19.4552 2.23331C19.228 1.38329 18.5584 0.713716 17.7084 0.486501C16.1677 0.0735625 9.98926 0.0735626 9.98926 0.0735626C9.98926 0.0735626 3.81077 0.0735625 2.2701 0.486501C1.42008 0.713716 0.750505 1.38329 0.52329 2.23331C0.110352 3.77398 0.110352 6.9888 0.110352 6.9888C0.110352 6.9888 0.110352 10.2036 0.52329 11.7443C0.750505 12.5943 1.42008 13.2639 2.2701 13.4911C3.81077 13.904 9.98926 13.904 9.98926 13.904C9.98926 13.904 16.1677 13.904 17.7084 13.4911C18.5584 13.2639 19.228 12.5943 19.4552 11.7443C19.8682 10.2036 19.8682 6.9888 19.8682 6.9888C19.8682 6.9888 19.8682 3.77398 19.4552 2.23331ZM8.01348 9.95247V4.02513L13.1466 6.9888L8.01348 9.95247Z"
                                                fill="#007F61"
                                        />
                                    </svg>
                                </div>
                                <div class="content">
                                    <h4 class="title">Youtubers</h4>
                                    <p class="desc">Increase your video views</p>
                                </div>
                            </a>
                            <a href="#" class="menu__item">
                                <div class="icon">
                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path
                                                d="M18.3332 12.6533V6.66667C18.3319 5.562 17.8925 4.50296 17.1114 3.72185C16.3302 2.94073 15.2712 2.50132 14.1665 2.5H5.83321C4.72855 2.50132 3.66951 2.94073 2.88839 3.72185C2.10728 4.50296 1.66786 5.562 1.66654 6.66667V12.6533C1.11097 12.849 0.642587 13.235 0.344342 13.7429C0.046097 14.2509 -0.06276 14.848 0.0370517 15.4285C0.136863 16.009 0.438902 16.5354 0.889672 16.9146C1.34044 17.2937 1.91085 17.5011 2.49987 17.5H17.4999C18.0889 17.5011 18.6593 17.2937 19.1101 16.9146C19.5608 16.5354 19.8629 16.009 19.9627 15.4285C20.0625 14.848 19.9537 14.2509 19.6554 13.7429C19.3572 13.235 18.8888 12.849 18.3332 12.6533ZM5.83321 4.16667H14.1665C14.8296 4.16667 15.4655 4.43006 15.9343 4.8989C16.4031 5.36774 16.6665 6.00363 16.6665 6.66667V12.5H13.2074C12.965 12.4998 12.7255 12.5525 12.5056 12.6544C12.2857 12.7563 12.0906 12.905 11.934 13.09L11.7282 13.3333H8.27071L8.06571 13.09C7.90913 12.905 7.71409 12.7563 7.49417 12.6544C7.27425 12.5525 7.03475 12.4998 6.79237 12.5H3.33321V6.66667C3.33321 6.00363 3.5966 5.36774 4.06544 4.8989C4.53428 4.43006 5.17017 4.16667 5.83321 4.16667ZM17.4999 15.8333H2.49987C2.27886 15.8333 2.0669 15.7455 1.91062 15.5893C1.75434 15.433 1.66654 15.221 1.66654 15C1.66654 14.779 1.75434 14.567 1.91062 14.4107C2.0669 14.2545 2.27886 14.1667 2.49987 14.1667H6.79321L6.99821 14.41C7.15469 14.5949 7.34961 14.7435 7.56937 14.8454C7.78913 14.9473 8.02847 15 8.27071 15H11.7282C11.9706 15.0002 12.2101 14.9475 12.43 14.8456C12.6499 14.7437 12.845 14.595 13.0015 14.41L13.2074 14.1667H17.4999C17.7209 14.1667 17.9328 14.2545 18.0891 14.4107C18.2454 14.567 18.3332 14.779 18.3332 15C18.3332 15.221 18.2454 15.433 18.0891 15.5893C17.9328 15.7455 17.7209 15.8333 17.4999 15.8333Z"
                                                fill="#007F61"
                                        />
                                    </svg>
                                </div>
                                <div class="content">
                                    <h4 class="title">Digital sellers</h4>
                                    <p class="desc">Sell any digital goods</p>
                                </div>
                            </a>
                            <a href="#" class="menu__item">
                                <div class="icon">
                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path
                                                d="M20 10.0608C20 15.0517 16.3383 19.1892 11.5583 19.94V12.9708H13.8825L14.325 10.0875H11.5583V8.21667C11.5583 7.4275 11.945 6.65917 13.1833 6.65917H14.4408V4.20417C14.4408 4.20417 13.2992 4.00917 12.2083 4.00917C9.93 4.00917 8.44167 5.39 8.44167 7.88917V10.0867H5.90917V12.97H8.44167V19.9392C3.6625 19.1875 0 15.0508 0 10.0608C0 4.53834 4.4775 0.0608368 10 0.0608368C15.5225 0.0608368 20 4.5375 20 10.0608Z"
                                                fill="#007F61"
                                        />
                                    </svg>
                                </div>
                                <div class="content">
                                    <h4 class="title">Facebook sellers</h4>
                                    <p class="desc">Retarget your factbook customer</p>
                                </div>
                            </a>
                            <a href="#" class="menu__item">
                                <div class="icon">
                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_707_2507)">
                                            <path
                                                    d="M20 8.3334C20 8.27257 19.9933 8.21192 19.98 8.15257L18.8967 3.26257C18.6954 2.33444 18.1811 1.50372 17.4401 0.909721C16.6991 0.315721 15.7764 -0.00544699 14.8267 6.99074e-05H5.17334C4.22421 -0.00468034 3.30228 0.316838 2.56194 0.910775C1.82161 1.50471 1.30783 2.335 1.10667 3.26257L0.0200011 8.15257C0.00667456 8.21192 -3.30499e-05 8.27257 1.14116e-06 8.3334V9.16674C-0.000671198 9.97807 0.295769 10.7616 0.833334 11.3692V15.8334C0.834658 16.9381 1.27407 17.9971 2.05518 18.7782C2.8363 19.5593 3.89534 19.9987 5 20.0001H15C16.1047 19.9987 17.1637 19.5593 17.9448 18.7782C18.7259 17.9971 19.1653 16.9381 19.1667 15.8334V11.3692C19.7042 10.7616 20.0007 9.97807 20 9.16674V8.3334ZM1.66667 8.42424L2.73333 3.62424C2.8542 3.06778 3.16252 2.56972 3.60668 2.21338C4.05084 1.85705 4.60391 1.66407 5.17334 1.66674H5.83333V4.16674C5.83333 4.38775 5.92113 4.59971 6.07741 4.75599C6.23369 4.91227 6.44565 5.00007 6.66667 5.00007C6.88768 5.00007 7.09964 4.91227 7.25592 4.75599C7.4122 4.59971 7.5 4.38775 7.5 4.16674V1.66674H12.5V4.16674C12.5 4.38775 12.5878 4.59971 12.7441 4.75599C12.9004 4.91227 13.1123 5.00007 13.3333 5.00007C13.5543 5.00007 13.7663 4.91227 13.9226 4.75599C14.0789 4.59971 14.1667 4.38775 14.1667 4.16674V1.66674H14.8267C15.3961 1.66407 15.9492 1.85705 16.3933 2.21338C16.8375 2.56972 17.1458 3.06778 17.2667 3.62424L18.3333 8.42424V9.16674C18.3333 9.60877 18.1577 10.0327 17.8452 10.3452C17.5326 10.6578 17.1087 10.8334 16.6667 10.8334H15.8333C15.3913 10.8334 14.9674 10.6578 14.6548 10.3452C14.3423 10.0327 14.1667 9.60877 14.1667 9.16674C14.1667 8.94572 14.0789 8.73376 13.9226 8.57748C13.7663 8.4212 13.5543 8.3334 13.3333 8.3334C13.1123 8.3334 12.9004 8.4212 12.7441 8.57748C12.5878 8.73376 12.5 8.94572 12.5 9.16674C12.5 9.60877 12.3244 10.0327 12.0118 10.3452C11.6993 10.6578 11.2754 10.8334 10.8333 10.8334H9.16667C8.72464 10.8334 8.30072 10.6578 7.98816 10.3452C7.6756 10.0327 7.5 9.60877 7.5 9.16674C7.5 8.94572 7.4122 8.73376 7.25592 8.57748C7.09964 8.4212 6.88768 8.3334 6.66667 8.3334C6.44565 8.3334 6.23369 8.4212 6.07741 8.57748C5.92113 8.73376 5.83333 8.94572 5.83333 9.16674C5.83333 9.60877 5.65774 10.0327 5.34518 10.3452C5.03262 10.6578 4.6087 10.8334 4.16667 10.8334H3.33333C2.89131 10.8334 2.46738 10.6578 2.15482 10.3452C1.84226 10.0327 1.66667 9.60877 1.66667 9.16674V8.42424ZM15 18.3334H5C4.33696 18.3334 3.70108 18.07 3.23223 17.6012C2.76339 17.1323 2.5 16.4964 2.5 15.8334V12.3942C2.77217 12.4647 3.05219 12.5003 3.33333 12.5001H4.16667C4.63985 12.5003 5.10763 12.3996 5.53875 12.2046C5.96988 12.0095 6.35442 11.7248 6.66667 11.3692C6.97892 11.7248 7.36346 12.0095 7.79458 12.2046C8.22571 12.3996 8.69349 12.5003 9.16667 12.5001H10.8333C11.3065 12.5003 11.7743 12.3996 12.2054 12.2046C12.6365 12.0095 13.0211 11.7248 13.3333 11.3692C13.6456 11.7248 14.0301 12.0095 14.4612 12.2046C14.8924 12.3996 15.3602 12.5003 15.8333 12.5001H16.6667C16.9478 12.5003 17.2278 12.4647 17.5 12.3942V15.8334C17.5 16.4964 17.2366 17.1323 16.7678 17.6012C16.2989 18.07 15.663 18.3334 15 18.3334Z"
                                                    fill="#007F61"
                                            />
                                        </g>
                                    </svg>
                                </div>
                                <div class="content">
                                    <h4 class="title">SME</h4>
                                    <p class="desc">Reach out & start getting first customers</p>
                                </div>
                            </a>
                            <a href="#" class="menu__item">
                                <div class="icon">
                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_707_2463)">
                                            <path
                                                    d="M13.3333 11.6667C13.3333 12.1267 12.96 12.5 12.5 12.5H11.6667C11.2067 12.5 10.8333 12.1267 10.8333 11.6667C10.8333 11.2067 11.2067 10.8333 11.6667 10.8333H12.5C12.96 10.8333 13.3333 11.2067 13.3333 11.6667ZM15.8333 10.8333H15C14.54 10.8333 14.1667 11.2067 14.1667 11.6667C14.1667 12.1267 14.54 12.5 15 12.5H15.8333C16.2933 12.5 16.6667 12.1267 16.6667 11.6667C16.6667 11.2067 16.2933 10.8333 15.8333 10.8333ZM12.5 14.1667H11.6667C11.2067 14.1667 10.8333 14.54 10.8333 15C10.8333 15.46 11.2067 15.8333 11.6667 15.8333H12.5C12.96 15.8333 13.3333 15.46 13.3333 15C13.3333 14.54 12.96 14.1667 12.5 14.1667ZM15.8333 14.1667H15C14.54 14.1667 14.1667 14.54 14.1667 15C14.1667 15.46 14.54 15.8333 15 15.8333H15.8333C16.2933 15.8333 16.6667 15.46 16.6667 15C16.6667 14.54 16.2933 14.1667 15.8333 14.1667ZM12.5 4.16667H11.6667C11.2067 4.16667 10.8333 4.54 10.8333 5C10.8333 5.46 11.2067 5.83333 11.6667 5.83333H12.5C12.96 5.83333 13.3333 5.46 13.3333 5C13.3333 4.54 12.96 4.16667 12.5 4.16667ZM15.8333 4.16667H15C14.54 4.16667 14.1667 4.54 14.1667 5C14.1667 5.46 14.54 5.83333 15 5.83333H15.8333C16.2933 5.83333 16.6667 5.46 16.6667 5C16.6667 4.54 16.2933 4.16667 15.8333 4.16667ZM12.5 7.5H11.6667C11.2067 7.5 10.8333 7.87333 10.8333 8.33333C10.8333 8.79333 11.2067 9.16667 11.6667 9.16667H12.5C12.96 9.16667 13.3333 8.79333 13.3333 8.33333C13.3333 7.87333 12.96 7.5 12.5 7.5ZM15.8333 7.5H15C14.54 7.5 14.1667 7.87333 14.1667 8.33333C14.1667 8.79333 14.54 9.16667 15 9.16667H15.8333C16.2933 9.16667 16.6667 8.79333 16.6667 8.33333C16.6667 7.87333 16.2933 7.5 15.8333 7.5ZM20 4.16667V15.8333C20 18.1308 18.1308 20 15.8333 20H4.16667C1.86917 20 0 18.1308 0 15.8333V7.715C0 6.58917 0.465 5.495 1.27583 4.71417L2.84917 3.19917C3.82167 2.26167 5.345 2.2625 6.3175 3.19917L7.5 4.33833V4.16667C7.5 1.86917 9.36917 0 11.6667 0H15.8333C18.1308 0 20 1.86917 20 4.16667ZM7.5 7.715C7.5 7.03917 7.22083 6.38333 6.73417 5.91417L5.16083 4.39917C4.99917 4.2425 4.79083 4.165 4.58333 4.165C4.37583 4.165 4.1675 4.2425 4.00583 4.39917L2.4325 5.91417C1.94583 6.3825 1.66667 7.03917 1.66667 7.715V15.8333C1.66667 17.2117 2.78833 18.3333 4.16667 18.3333H7.5V7.715ZM18.3333 4.16667C18.3333 2.78833 17.2117 1.66667 15.8333 1.66667H11.6667C10.2883 1.66667 9.16667 2.78833 9.16667 4.16667V18.3333H15.8333C17.2117 18.3333 18.3333 17.2117 18.3333 15.8333V4.16667ZM5 10.8333H4.16667C3.70667 10.8333 3.33333 11.2067 3.33333 11.6667C3.33333 12.1267 3.70667 12.5 4.16667 12.5H5C5.46 12.5 5.83333 12.1267 5.83333 11.6667C5.83333 11.2067 5.46 10.8333 5 10.8333ZM5 7.5H4.16667C3.70667 7.5 3.33333 7.87333 3.33333 8.33333C3.33333 8.79333 3.70667 9.16667 4.16667 9.16667H5C5.46 9.16667 5.83333 8.79333 5.83333 8.33333C5.83333 7.87333 5.46 7.5 5 7.5ZM5 14.1667H4.16667C3.70667 14.1667 3.33333 14.54 3.33333 15C3.33333 15.46 3.70667 15.8333 4.16667 15.8333H5C5.46 15.8333 5.83333 15.46 5.83333 15C5.83333 14.54 5.46 14.1667 5 14.1667Z"
                                                    fill="#007F61"
                                            />
                                        </g>
                                    </svg>
                                </div>
                                <div class="content">
                                    <h4 class="title">Enterprises</h4>
                                    <p class="desc">Mass marketing and grow on scale</p>
                                </div>
                            </a>
                            <a href="#" class="menu__item">
                                <div class="icon">
                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_707_2514)">
                                            <path
                                                    d="M18.9275 3.3975C18.6931 3.1162 18.3996 2.88996 18.0679 2.73485C17.7363 2.57973 17.3745 2.49955 17.0083 2.5H3.535L3.5 2.2075C3.42837 1.59951 3.13615 1.03894 2.67874 0.632065C2.22133 0.225186 1.63052 0.000284828 1.01833 0L0.833333 0C0.61232 0 0.400358 0.0877974 0.244078 0.244078C0.0877974 0.400358 0 0.61232 0 0.833333C0 1.05435 0.0877974 1.26631 0.244078 1.42259C0.400358 1.57887 0.61232 1.66667 0.833333 1.66667H1.01833C1.22244 1.66669 1.41945 1.74163 1.57198 1.87726C1.72451 2.0129 1.82195 2.19979 1.84583 2.4025L2.9925 12.1525C3.11154 13.1665 3.59873 14.1015 4.36159 14.78C5.12445 15.4585 6.10988 15.8334 7.13083 15.8333H15.8333C16.0543 15.8333 16.2663 15.7455 16.4226 15.5893C16.5789 15.433 16.6667 15.221 16.6667 15C16.6667 14.779 16.5789 14.567 16.4226 14.4107C16.2663 14.2545 16.0543 14.1667 15.8333 14.1667H7.13083C6.61505 14.1652 6.11233 14.0043 5.69161 13.7059C5.27089 13.4075 4.95276 12.9863 4.78083 12.5H14.7142C15.6911 12.5001 16.6369 12.1569 17.3865 11.5304C18.1361 10.9039 18.6417 10.0339 18.815 9.0725L19.4692 5.44417C19.5345 5.08417 19.5198 4.71422 19.4262 4.36053C19.3326 4.00684 19.1623 3.67806 18.9275 3.3975ZM17.8333 5.14833L17.1783 8.77667C17.0743 9.35417 16.7704 9.87666 16.3199 10.2527C15.8694 10.6287 15.301 10.8342 14.7142 10.8333H4.51583L3.73167 4.16667H17.0083C17.1307 4.16594 17.2518 4.19218 17.3629 4.24355C17.4741 4.29491 17.5725 4.37012 17.6513 4.46384C17.73 4.55756 17.7872 4.66748 17.8186 4.78578C17.8501 4.90409 17.8551 5.02787 17.8333 5.14833Z"
                                                    fill="#007F61"
                                            />
                                            <path
                                                    d="M5.83366 20C6.75413 20 7.50033 19.2538 7.50033 18.3333C7.50033 17.4129 6.75413 16.6667 5.83366 16.6667C4.91318 16.6667 4.16699 17.4129 4.16699 18.3333C4.16699 19.2538 4.91318 20 5.83366 20Z"
                                                    fill="#007F61"
                                            />
                                            <path
                                                    d="M14.1667 20C15.0871 20 15.8333 19.2538 15.8333 18.3333C15.8333 17.4129 15.0871 16.6667 14.1667 16.6667C13.2462 16.6667 12.5 17.4129 12.5 18.3333C12.5 19.2538 13.2462 20 14.1667 20Z"
                                                    fill="#007F61"
                                            />
                                        </g>
                                    </svg>
                                </div>
                                <div class="content">
                                    <h4 class="title">Marketers</h4>
                                    <p class="desc">Run marketing campaigns for your agency</p>
                                </div>
                            </a>
                            <a href="#" class="menu__item">
                                <div class="icon">
                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_707_2468)">
                                            <path
                                                    d="M10 7.5C14.945 7.37 14.9442 0.129167 10 0C5.055 0.13 5.05583 7.37083 10 7.5ZM10 1.66667C12.7383 1.71583 12.7375 5.785 10 5.83333C7.2625 5.78417 7.2625 1.715 10 1.66667ZM18.5033 9.30167C17.5508 8.5075 16.3033 8.17917 15.0875 8.40083L11.9033 8.98C11.1425 9.11833 10.4808 9.50833 10 10.0542C9.51833 9.50833 8.8575 9.11833 8.09583 8.98L4.91167 8.40083C3.69417 8.18083 2.44833 8.5075 1.49667 9.30167C0.545 10.0958 0 11.2617 0 12.5008V14.8283C0 16.8425 1.43917 18.5667 3.42167 18.9275L8.65833 19.88C9.54833 20.0417 10.4508 20.0417 11.3408 19.88L16.5783 18.9275C18.5608 18.5667 19.9992 16.8425 19.9992 14.8283V12.5008C19.9992 11.2617 19.4542 10.0958 18.5025 9.3025L18.5033 9.30167ZM9.16667 18.2742C9.09667 18.2642 9.02667 18.2525 8.95667 18.24L3.72 17.2875C2.53 17.0708 1.66667 16.0367 1.66667 14.8275V12.5C1.66667 11.7567 1.99417 11.0575 2.565 10.5808C3.13583 10.1033 3.89 9.9075 4.61417 10.0408L7.79833 10.62C8.59167 10.7642 9.16667 11.4533 9.16667 12.26V18.2742ZM18.3333 14.8283C18.3333 16.0375 17.47 17.0717 16.2808 17.2883L11.0433 18.2408C10.9733 18.2533 10.9033 18.265 10.8333 18.275V12.2608C10.8333 11.455 11.4083 10.765 12.2017 10.6208L15.3858 10.0417C16.115 9.90833 16.8642 10.1058 17.4358 10.5817C18.0067 11.0583 18.3333 11.7575 18.3333 12.5008V14.8283Z"
                                                    fill="#007F61"
                                            />
                                        </g>
                                    </svg>
                                </div>
                                <div class="content">
                                    <h4 class="title">Coaches</h4>
                                    <p class="desc">Sell e-book or courses</p>
                                </div>
                            </a>
                            <a href="#" class="menu__item">
                                <div class="icon">
                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_707_2521)">
                                            <path
                                                    d="M13.3333 0H6.66667C4.36917 0 2.5 1.86917 2.5 4.16667V15.8333C2.5 18.1308 4.36917 20 6.66667 20H8.33333C8.79333 20 9.16667 19.6267 9.16667 19.1667V15H10.8333V19.1667C10.8333 19.6267 11.2067 20 11.6667 20H13.3333C15.6308 20 17.5 18.1308 17.5 15.8333V4.16667C17.5 1.86917 15.6308 0 13.3333 0ZM15.8333 15.8333C15.8333 17.2117 14.7117 18.3333 13.3333 18.3333H12.5V15H13.3333C13.7933 15 14.1667 14.6267 14.1667 14.1667C14.1667 13.7067 13.7933 13.3333 13.3333 13.3333H6.66667C6.20667 13.3333 5.83333 13.7067 5.83333 14.1667C5.83333 14.6267 6.20667 15 6.66667 15H7.5V18.3333H6.66667C5.28833 18.3333 4.16667 17.2117 4.16667 15.8333V4.16667C4.16667 2.78833 5.28833 1.66667 6.66667 1.66667H13.3333C14.7117 1.66667 15.8333 2.78833 15.8333 4.16667V15.8333ZM9.16667 10.8333C9.16667 11.2933 8.79333 11.6667 8.33333 11.6667H7.5C7.04 11.6667 6.66667 11.2933 6.66667 10.8333C6.66667 10.3733 7.04 10 7.5 10H8.33333C8.79333 10 9.16667 10.3733 9.16667 10.8333ZM13.3333 10.8333C13.3333 11.2933 12.96 11.6667 12.5 11.6667H11.6667C11.2067 11.6667 10.8333 11.2933 10.8333 10.8333C10.8333 10.3733 11.2067 10 11.6667 10H12.5C12.96 10 13.3333 10.3733 13.3333 10.8333ZM9.16667 4.16667C9.16667 4.62667 8.79333 5 8.33333 5H7.5C7.04 5 6.66667 4.62667 6.66667 4.16667C6.66667 3.70667 7.04 3.33333 7.5 3.33333H8.33333C8.79333 3.33333 9.16667 3.70667 9.16667 4.16667ZM13.3333 4.16667C13.3333 4.62667 12.96 5 12.5 5H11.6667C11.2067 5 10.8333 4.62667 10.8333 4.16667C10.8333 3.70667 11.2067 3.33333 11.6667 3.33333H12.5C12.96 3.33333 13.3333 3.70667 13.3333 4.16667ZM9.16667 7.5C9.16667 7.96 8.79333 8.33333 8.33333 8.33333H7.5C7.04 8.33333 6.66667 7.96 6.66667 7.5C6.66667 7.04 7.04 6.66667 7.5 6.66667H8.33333C8.79333 6.66667 9.16667 7.04 9.16667 7.5ZM13.3333 7.5C13.3333 7.96 12.96 8.33333 12.5 8.33333H11.6667C11.2067 8.33333 10.8333 7.96 10.8333 7.5C10.8333 7.04 11.2067 6.66667 11.6667 6.66667H12.5C12.96 6.66667 13.3333 7.04 13.3333 7.5Z"
                                                    fill="#007F61"
                                            />
                                        </g>
                                    </svg>
                                </div>
                                <div class="content">
                                    <h4 class="title">Hotels</h4>
                                    <p class="desc">Run promotion on off season for guests</p>
                                </div>
                            </a>
                            <a href="#" class="menu__item">
                                <div class="icon">
                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_707_2473)">
                                            <path
                                                    d="M15.8336 10H13.6553L14.1053 6.39083C14.1839 6.02575 14.1802 5.64774 14.0944 5.28427C14.0087 4.92081 13.843 4.581 13.6095 4.28956C13.376 3.99812 13.0805 3.76236 12.7445 3.5994C12.4085 3.43645 12.0404 3.3504 11.6669 3.3475H9.69277C9.7836 2.705 9.7286 1.675 10.6378 1.67083H13.3336C13.5546 1.67083 13.7666 1.58304 13.9229 1.42675C14.0791 1.27047 14.1669 1.05851 14.1669 0.837499C14.1669 0.616485 14.0791 0.404524 13.9229 0.248243C13.7666 0.091963 13.5546 0.00416565 13.3336 0.00416565H10.6378C10.0287 0.00454059 9.44068 0.227263 8.98419 0.630508C8.5277 1.03375 8.23413 1.58978 8.1586 2.19417L8.01443 3.3475H2.50027C2.13427 3.35142 1.77352 3.43511 1.44318 3.59273C1.11283 3.75035 0.820825 3.9781 0.587511 4.26012C0.354198 4.54215 0.185188 4.87165 0.0922576 5.22568C-0.000672408 5.57971 -0.0152866 5.94974 0.0494335 6.31L1.31027 16.3583C1.43776 17.3648 1.9277 18.2902 2.68837 18.9615C3.44904 19.6327 4.42828 20.0037 5.44277 20.005L15.8336 19.995C16.3808 19.995 16.9226 19.8872 17.4281 19.6778C17.9336 19.4684 18.393 19.1615 18.7799 18.7746C19.1668 18.3877 19.4737 17.9284 19.6831 17.4228C19.8925 16.9173 20.0003 16.3755 20.0003 15.8283V14.1667C20.0003 13.6195 19.8925 13.0777 19.6831 12.5722C19.4737 12.0666 19.1668 11.6073 18.7799 11.2204C18.393 10.8335 17.9336 10.5266 17.4281 10.3172C16.9226 10.1078 16.3808 10 15.8336 10ZM18.3336 14.1667H8.3336C8.3336 13.5036 8.59699 12.8677 9.06583 12.3989C9.53467 11.9301 10.1706 11.6667 10.8336 11.6667H15.8336C16.4966 11.6667 17.1325 11.9301 17.6014 12.3989C18.0702 12.8677 18.3336 13.5036 18.3336 14.1667ZM11.6669 5.01333C11.7986 5.01404 11.9282 5.0456 12.0455 5.10547C12.1628 5.16533 12.2643 5.25185 12.3421 5.35807C12.4199 5.46429 12.4717 5.58726 12.4934 5.71712C12.5151 5.84698 12.506 5.98011 12.4669 6.10583L12.3944 6.66667H9.27777L9.48443 5.01167L11.6669 5.01333ZM1.8536 5.325C1.93135 5.22814 2.02977 5.14989 2.14165 5.09596C2.25354 5.04204 2.37606 5.01381 2.50027 5.01333H7.8061L7.5986 6.66667H1.77027L1.68693 6.025C1.66022 5.9033 1.66134 5.77714 1.6902 5.65594C1.71906 5.53473 1.77491 5.4216 1.8536 5.325ZM2.9636 16.1517L1.98027 8.33333H12.1861L11.9769 10H10.8336C9.72853 10 8.66872 10.439 7.88732 11.2204C7.10592 12.0018 6.66693 13.0616 6.66693 14.1667C6.63193 15.5283 6.5836 17.2833 7.53027 18.3417H5.44277C4.83368 18.3413 4.24568 18.1186 3.78919 17.7153C3.3327 17.3121 3.03913 16.7561 2.9636 16.1517ZM15.8336 18.3333H10.8336C10.1706 18.3333 9.53467 18.0699 9.06583 17.6011C8.59699 17.1323 8.3336 16.4964 8.3336 15.8333H11.4169C11.7394 15.9883 13.8128 17.5925 14.1669 17.5C14.5136 17.5983 16.6086 15.9808 16.9169 15.8333H18.3336C18.3336 16.4964 18.0702 17.1323 17.6014 17.6011C17.1325 18.0699 16.4966 18.3333 15.8336 18.3333Z"
                                                    fill="#007F61"
                                            />
                                        </g>
                                    </svg>
                                </div>
                                <div class="content">
                                    <h4 class="title">Restaurants</h4>
                                    <p class="desc">Offer coupons for growing sales</p>
                                </div>
                            </a>
                            <a href="#" class="menu__item">
                                <div class="icon">
                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_707_2526)">
                                            <path
                                                    d="M19.9997 11.0925C19.9995 11.448 19.9148 11.7984 19.7524 12.1147C19.59 12.431 19.3547 12.7041 19.0659 12.9114C18.777 13.1187 18.443 13.2543 18.0914 13.3069C17.7398 13.3596 17.3807 13.3278 17.0438 13.2142L12.4997 11.5975V14.8683L13.8713 15.7683C14.2184 15.9955 14.5034 16.3057 14.7004 16.6708C14.8975 17.0359 15.0003 17.4443 14.9997 17.8592C14.9996 18.2018 14.9169 18.5394 14.7585 18.8433C14.6001 19.1472 14.3707 19.4083 14.0898 19.6046C13.809 19.8009 13.4849 19.9266 13.1451 19.9709C12.8053 20.0152 12.4598 19.9769 12.138 19.8592L9.99966 19.0833L7.86633 19.8675C7.54506 19.9855 7.20009 20.0243 6.86064 19.9806C6.52119 19.937 6.19727 19.8121 5.91633 19.6167C5.61964 19.3845 5.38335 19.0841 5.22748 18.7411C5.07161 18.3981 5.00078 18.0226 5.02098 17.6464C5.04118 17.2702 5.15182 16.9044 5.34352 16.5801C5.53522 16.2557 5.80232 15.9824 6.12216 15.7833L7.49966 14.8708L7.49966 11.5975L2.96883 13.2108C2.63027 13.3263 2.26905 13.3594 1.91514 13.3074C1.56123 13.2554 1.22482 13.1197 0.933825 12.9117C0.619076 12.6638 0.371294 12.3412 0.213025 11.9732C0.0547558 11.6052 -0.00897571 11.2035 0.0276294 10.8045C0.0642345 10.4056 0.200014 10.0222 0.422613 9.68909C0.645213 9.35603 0.947565 9.08391 1.30216 8.8975L7.49966 5.35V2.58917C7.49208 1.98647 7.69659 1.40029 8.07741 0.933096C8.45823 0.465902 8.99115 0.147423 9.58299 0.0333328C9.94161 -0.0272846 10.3091 -0.00892448 10.6599 0.0871315C11.0107 0.183187 11.3363 0.354626 11.614 0.589485C11.8917 0.824347 12.1149 1.11697 12.2678 1.44695C12.4208 1.77692 12.4999 2.1363 12.4997 2.5V5.35L18.7113 8.90583C19.1023 9.12139 19.4282 9.43808 19.6549 9.82277C19.8815 10.2075 20.0006 10.646 19.9997 11.0925ZM10.833 15.3183V10.4167C10.8341 10.2836 10.8669 10.1528 10.9287 10.0349C10.9904 9.91708 11.0793 9.81561 11.188 9.73891C11.2967 9.66221 11.4221 9.61248 11.5538 9.59383C11.6855 9.57519 11.8198 9.58815 11.9455 9.63167L17.5897 11.64C17.6743 11.6668 17.7641 11.6733 17.8517 11.6588C17.9394 11.6443 18.0223 11.6093 18.0938 11.5567C18.1771 11.4726 18.2393 11.3701 18.2754 11.2574C18.3114 11.1447 18.3203 11.025 18.3013 10.9083C18.2823 10.7915 18.2359 10.6808 18.166 10.5854C18.096 10.49 18.0045 10.4125 17.8988 10.3592L11.2497 6.55667C11.1227 6.48339 11.0174 6.37793 10.9442 6.25093C10.8711 6.12394 10.8327 5.97989 10.833 5.83333L10.833 2.5C10.833 2.37819 10.8064 2.25784 10.7549 2.14744C10.7034 2.03704 10.6284 1.93927 10.535 1.86102C10.4417 1.78276 10.3323 1.72592 10.2146 1.6945C10.0969 1.66308 9.97376 1.65785 9.85383 1.67916C9.65199 1.72852 9.47337 1.84601 9.34811 2.0118C9.22286 2.17759 9.15865 2.38152 9.16633 2.58917L9.16633 5.83333C9.16661 5.97989 9.12825 6.12394 9.05509 6.25093C8.98194 6.37793 8.87658 6.48339 8.74966 6.55667L2.11549 10.3525C2.00639 10.4031 1.91116 10.4794 1.83795 10.5748C1.76474 10.6703 1.71572 10.782 1.69508 10.9005C1.67445 11.019 1.68281 11.1407 1.71945 11.2553C1.75609 11.3698 1.81992 11.4738 1.90549 11.5583C1.97929 11.6116 2.06479 11.6465 2.15482 11.66C2.24486 11.6735 2.33681 11.6652 2.42299 11.6358L8.05383 9.63583C8.17921 9.59243 8.31312 9.5794 8.44452 9.59783C8.57592 9.61627 8.70108 9.66563 8.80968 9.74186C8.91829 9.81809 9.00725 9.91901 9.06926 10.0363C9.13126 10.1536 9.16453 10.284 9.16633 10.4167V15.3183C9.16635 15.456 9.13226 15.5915 9.06711 15.7128C9.00197 15.8341 8.90779 15.9373 8.79299 16.0133L7.04299 17.1742C6.69216 17.3642 6.51216 18.0358 6.86799 18.2492C6.92878 18.2927 6.99945 18.3205 7.07365 18.33C7.14784 18.3394 7.22322 18.3303 7.29299 18.3033L9.71466 17.41C9.90026 17.3418 10.1041 17.3418 10.2897 17.41L12.7147 18.2983C12.7844 18.3231 12.8591 18.3308 12.9325 18.3208C13.0058 18.3107 13.0757 18.2832 13.1363 18.2406C13.1968 18.1981 13.2463 18.1416 13.2805 18.0759C13.3147 18.0103 13.3327 17.9374 13.333 17.8633C13.3331 17.7249 13.2987 17.5887 13.2329 17.4669C13.1671 17.3452 13.0721 17.2417 12.9563 17.1658L11.2063 16.0192C11.0907 15.9426 10.996 15.8385 10.9308 15.7161C10.8656 15.5937 10.832 15.457 10.833 15.3183Z"
                                                    fill="#007F61"
                                            />
                                        </g>
                                    </svg>
                                </div>
                                <div class="content">
                                    <h4 class="title">Flight booking</h4>
                                    <p class="desc">Sell tickets promoting offers</p>
                                </div>
                            </a>
                            <a href="#" class="menu__item">
                                <div class="icon">
                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_707_2478)">
                                            <path
                                                    d="M14.827 6.01C14.4567 4.41774 13.5142 3.01704 12.1788 2.07415C10.8434 1.13127 9.20802 0.711932 7.58364 0.895848C5.95925 1.07976 4.45907 1.85411 3.36824 3.0717C2.2774 4.2893 1.67197 5.86525 1.66702 7.5C1.6663 8.56533 1.92364 9.61498 2.41702 10.5592C1.51796 11.041 0.805687 11.8094 0.39337 12.7423C-0.0189474 13.6753 -0.107659 14.7193 0.14133 15.7084C0.390319 16.6976 0.962726 17.5752 1.76761 18.2018C2.57249 18.8283 3.56368 19.1679 4.58369 19.1667H13.3337C14.9663 19.1591 16.5393 18.5527 17.7545 17.4625C18.9698 16.3723 19.7428 14.8741 19.9269 13.2519C20.111 11.6298 19.6935 9.99642 18.7535 8.6616C17.8135 7.32678 16.4164 6.38328 14.827 6.01ZM13.3337 17.5H4.58369C3.87404 17.5021 3.18809 17.2448 2.65495 16.7764C2.12181 16.3081 1.77826 15.661 1.68895 14.957C1.59964 14.2529 1.77074 13.5406 2.17005 12.9539C2.56935 12.3673 3.16932 11.9468 3.85702 11.7717C3.98928 11.7376 4.11115 11.6716 4.21189 11.5794C4.31264 11.4872 4.38918 11.3716 4.43478 11.2429C4.48038 11.1142 4.49364 10.9762 4.4734 10.8411C4.45315 10.7061 4.40003 10.578 4.31869 10.4683C3.67798 9.61145 3.33236 8.56993 3.33369 7.5C3.34319 6.23832 3.82934 5.02688 4.69464 4.10863C5.55993 3.19038 6.74039 2.63321 7.99929 2.54886C9.25818 2.46451 10.5024 2.85922 11.4825 3.65383C12.4625 4.44844 13.106 5.5842 13.2837 6.83333C13.3077 7.01471 13.3907 7.18316 13.5199 7.31268C13.6491 7.4422 13.8174 7.5256 13.9987 7.55C15.2477 7.7277 16.3834 8.37098 17.178 9.35087C17.9726 10.3308 18.3674 11.5748 18.2833 12.8336C18.1992 14.0924 17.6423 15.2728 16.7244 16.1382C15.8064 17.0037 14.5952 17.4901 13.3337 17.5Z"
                                                    fill="#007F61"
                                            />
                                        </g>
                                    </svg>
                                </div>
                                <div class="content">
                                    <h4 class="title">SAAS products</h4>
                                    <p class="desc">Launch promotion or get early adopters</p>
                                </div>
                            </a>
                            <a href="#" class="menu__item">
                                <div class="icon">
                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path
                                                d="M17.5002 10.3533V9.16666C17.5002 7.17754 16.7101 5.26989 15.3035 3.86336C13.897 2.45684 11.9894 1.66666 10.0002 1.66666C8.01112 1.66666 6.10347 2.45684 4.69694 3.86336C3.29042 5.26989 2.50024 7.17754 2.50024 9.16666V10.3533C1.62621 10.7382 0.910911 11.4116 0.474095 12.2609C0.0372792 13.1101 -0.0945389 14.0837 0.100708 15.0185C0.295956 15.9534 0.806416 16.7928 1.54664 17.3962C2.28685 17.9996 3.2119 18.3305 4.16691 18.3333C4.60894 18.3333 5.03286 18.1577 5.34542 17.8452C5.65798 17.5326 5.83358 17.1087 5.83358 16.6667V11.6667C5.83358 11.2246 5.65798 10.8007 5.34542 10.4882C5.03286 10.1756 4.60894 10 4.16691 10V9.16666C4.16691 7.61957 4.78149 6.13584 5.87545 5.04187C6.96942 3.94791 8.45315 3.33333 10.0002 3.33333C11.5473 3.33333 13.0311 3.94791 14.125 5.04187C15.219 6.13584 15.8336 7.61957 15.8336 9.16666V10C15.3916 10 14.9676 10.1756 14.6551 10.4882C14.3425 10.8007 14.1669 11.2246 14.1669 11.6667V16.6667C14.1669 17.1087 14.3425 17.5326 14.6551 17.8452C14.9676 18.1577 15.3916 18.3333 15.8336 18.3333C16.7886 18.3305 17.7136 17.9996 18.4539 17.3962C19.1941 16.7928 19.7045 15.9534 19.8998 15.0185C20.095 14.0837 19.9632 13.1101 19.5264 12.2609C19.0896 11.4116 18.3743 10.7382 17.5002 10.3533ZM4.16691 16.6667C3.50387 16.6667 2.86798 16.4033 2.39914 15.9344C1.9303 15.4656 1.66691 14.8297 1.66691 14.1667C1.66691 13.5036 1.9303 12.8677 2.39914 12.3989C2.86798 11.9301 3.50387 11.6667 4.16691 11.6667V16.6667ZM15.8336 16.6667V11.6667C16.4966 11.6667 17.1325 11.9301 17.6013 12.3989C18.0702 12.8677 18.3336 13.5036 18.3336 14.1667C18.3336 14.8297 18.0702 15.4656 17.6013 15.9344C17.1325 16.4033 16.4966 16.6667 15.8336 16.6667Z"
                                                fill="#007F61"
                                        />
                                    </svg>
                                </div>
                                <div class="content">
                                    <h4 class="title">Consultation service</h4>
                                    <p class="desc">Reachout personally and provide services</p>
                                </div>
                            </a>
                            <a href="#" class="menu__item">
                                <div class="icon">
                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_707_2485)">
                                            <path
                                                    d="M4.16667 19.1667C3.34258 19.1667 2.537 18.9223 1.85179 18.4645C1.16659 18.0066 0.632536 17.3559 0.317171 16.5945C0.00180535 15.8332 -0.0807085 14.9954 0.0800632 14.1871C0.240835 13.3789 0.637672 12.6364 1.22039 12.0537C1.80311 11.471 2.54554 11.0742 3.35379 10.9134C4.16205 10.7526 4.99982 10.8351 5.76118 11.1505C6.52254 11.4659 7.17329 11.9999 7.63112 12.6851C8.08896 13.3703 8.33333 14.1759 8.33333 15C8.33201 16.1047 7.8926 17.1637 7.11149 17.9448C6.33037 18.7259 5.27133 19.1653 4.16667 19.1667ZM4.16667 12.5C3.67222 12.5 3.18887 12.6466 2.77774 12.9213C2.36662 13.196 2.04619 13.5865 1.85697 14.0433C1.66775 14.5001 1.61824 15.0028 1.71471 15.4877C1.81117 15.9727 2.04927 16.4181 2.3989 16.7678C2.74853 17.1174 3.19399 17.3555 3.67894 17.452C4.1639 17.5484 4.66656 17.4989 5.12338 17.3097C5.58019 17.1205 5.97064 16.8 6.24534 16.3889C6.52005 15.9778 6.66667 15.4944 6.66667 15C6.66667 14.337 6.40328 13.7011 5.93444 13.2322C5.46559 12.7634 4.82971 12.5 4.16667 12.5ZM15.8333 19.1667C15.0092 19.1667 14.2037 18.9223 13.5185 18.4645C12.8333 18.0066 12.2992 17.3559 11.9838 16.5945C11.6685 15.8332 11.586 14.9954 11.7467 14.1871C11.9075 13.3789 12.3043 12.6364 12.8871 12.0537C13.4698 11.471 14.2122 11.0742 15.0205 10.9134C15.8287 10.7526 16.6665 10.8351 17.4279 11.1505C18.1892 11.4659 18.84 11.9999 19.2978 12.6851C19.7556 13.3703 20 14.1759 20 15C19.9987 16.1047 19.5593 17.1637 18.7782 17.9448C17.997 18.7259 16.938 19.1653 15.8333 19.1667ZM15.8333 12.5C15.3389 12.5 14.8555 12.6466 14.4444 12.9213C14.0333 13.196 13.7129 13.5865 13.5236 14.0433C13.3344 14.5001 13.2849 15.0028 13.3814 15.4877C13.4778 15.9727 13.7159 16.4181 14.0656 16.7678C14.4152 17.1174 14.8607 17.3555 15.3456 17.452C15.8306 17.5484 16.3332 17.4989 16.79 17.3097C17.2469 17.1205 17.6373 16.8 17.912 16.3889C18.1867 15.9778 18.3333 15.4944 18.3333 15C18.3333 14.337 18.0699 13.7011 17.6011 13.2322C17.1323 12.7634 16.4964 12.5 15.8333 12.5ZM10.8333 15V11.6667C10.8332 11.5466 10.8072 11.4281 10.757 11.319C10.7068 11.21 10.6336 11.1131 10.5425 11.035L8.6375 9.3975C8.54755 9.32116 8.47508 9.22635 8.42504 9.11951C8.375 9.01267 8.34855 8.8963 8.3475 8.77833C8.34371 8.66941 8.36198 8.56085 8.40122 8.45917C8.44046 8.35749 8.49986 8.2648 8.57584 8.18666L10.2117 6.885C10.3761 6.73637 10.5926 6.65882 10.814 6.66928C11.0354 6.67974 11.2437 6.77736 11.3933 6.94083L13.56 8.94083C13.714 9.08331 13.916 9.16246 14.1258 9.1625H16.6667C16.8877 9.1625 17.0996 9.0747 17.2559 8.91842C17.4122 8.76214 17.5 8.55018 17.5 8.32916C17.5 8.10815 17.4122 7.89619 17.2559 7.73991C17.0996 7.58363 16.8877 7.49583 16.6667 7.49583H14.45L12.5525 5.74333C12.1081 5.2861 11.5046 5.01778 10.8675 4.99419C10.2303 4.97059 9.60862 5.19354 9.13167 5.61666L7.495 6.91666C7.23374 7.15522 7.02609 7.44651 6.88577 7.77129C6.74546 8.09606 6.67567 8.44692 6.68103 8.80067C6.68638 9.15441 6.76676 9.503 6.91685 9.82337C7.06693 10.1438 7.28331 10.4286 7.55167 10.6592L9.16667 12.0492V15C9.16667 15.221 9.25447 15.433 9.41075 15.5893C9.56703 15.7455 9.77899 15.8333 10 15.8333C10.221 15.8333 10.433 15.7455 10.5893 15.5893C10.7455 15.433 10.8333 15.221 10.8333 15ZM13.75 0.833328C13.338 0.833328 12.9352 0.955514 12.5926 1.18443C12.25 1.41335 11.9829 1.73873 11.8253 2.1194C11.6676 2.50008 11.6263 2.91897 11.7067 3.3231C11.7871 3.72723 11.9855 4.09844 12.2769 4.3898C12.5682 4.68116 12.9394 4.87958 13.3436 4.95996C13.7477 5.04035 14.1666 4.99909 14.5473 4.84141C14.9279 4.68373 15.2533 4.4167 15.4822 4.0741C15.7112 3.7315 15.8333 3.32871 15.8333 2.91666C15.8333 2.36413 15.6138 1.83422 15.2231 1.44352C14.8324 1.05282 14.3025 0.833328 13.75 0.833328Z"
                                                    fill="#007F61"
                                            />
                                        </g>
                                    </svg>
                                </div>
                                <div class="content">
                                    <h4 class="title">Ride sharing</h4>
                                    <p class="desc">Run promotional offers to retain customers</p>
                                </div>
                            </a>
                            <a href="#" class="menu__item">
                                <div class="icon">
                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_707_2538)">
                                            <path
                                                    d="M1.66667 11.6667C2.58714 11.6667 3.33333 10.9205 3.33333 9.99999C3.33333 9.07952 2.58714 8.33333 1.66667 8.33333C0.746192 8.33333 0 9.07952 0 9.99999C0 10.9205 0.746192 11.6667 1.66667 11.6667Z"
                                                    fill="#007F61"
                                            />
                                            <path
                                                    d="M9.99967 11.6667C10.9201 11.6667 11.6663 10.9205 11.6663 9.99999C11.6663 9.07952 10.9201 8.33333 9.99967 8.33333C9.0792 8.33333 8.33301 9.07952 8.33301 9.99999C8.33301 10.9205 9.0792 11.6667 9.99967 11.6667Z"
                                                    fill="#007F61"
                                            />
                                            <path
                                                    d="M18.3337 11.6667C19.2541 11.6667 20.0003 10.9205 20.0003 9.99999C20.0003 9.07952 19.2541 8.33333 18.3337 8.33333C17.4132 8.33333 16.667 9.07952 16.667 9.99999C16.667 10.9205 17.4132 11.6667 18.3337 11.6667Z"
                                                    fill="#007F61"
                                            />
                                        </g>
                                    </svg>
                                </div>
                                <div class="content">
                                    <h4 class="title">And More</h4>
                                    <p class="desc">Use SaleMag for any and every use cases</p>
                                </div>
                            </a>
                        </div>
                    </li>
                    <li><a href="index.html#pricing" class="nav__link">pricing</a></li>
                    <li><a href="index.html#faq" class="nav__link">FAQ</a></li>
                    <li><a href="cost-calculator.html" class="nav__link">Cost Calculator</a></li>
                </ul>
            </div>
        </div>
    </div>
</div>
<!-- Header Flyout Menu End -->

<!-- JS -->
<script src="{{ static_asset('website/themes/salemag/assets/js/jquery-3.7.1.min.js')}}"></script>
<!-- bootstrap js -->
<script src="{{ static_asset('website/themes/salemag/assets/js/bootstrap.min.js')}}"></script>
<script src="{{ static_asset('website/themes/salemag/assets/js/bootstrap.bundle.min.js')}}"></script>
<!-- swiper slider -->
<script src="{{ static_asset('website/themes/salemag/assets/js/swiper-bundle.min.js')}}"></script>
<!-- aos animation -->
<script src="{{ static_asset('website/themes/salemag/assets/js/aos.js')}}"></script>
<!-- accordion js -->
<script src="{{ static_asset('website/themes/salemag/assets/js/accordion.min.js')}}"></script>
<!-- main js -->
<script src="{{ static_asset('website/themes/salemag/assets/js/scripts.js')}}"></script>
<script>
    //facebook chat
    @if (setting('is_tawk_messenger_activated') == 1)

    var Tawk_API = Tawk_API || {},
        Tawk_LoadStart = new Date();
    (function () {
        var s1 = document.createElement("script"),
            s0 = document.getElementsByTagName("script")[0];
        s1.async = true;
        s1.src = 'https://embed.tawk.to/{{ setting('tawk_property_id') }}/{{ setting('tawk_widget_id') }}';
        s1.charset = 'UTF-8';
        s1.setAttribute('crossorigin', '*');
        s0.parentNode.insertBefore(s1, s0);
    })();
    @endif

    @if (setting('is_facebook_messenger_activated') == 1)
        window.fbAsyncInit = function () {
        FB.init({
            appId: 'facebook-developer-app-id',

            autoLogAppEvents: true,
            xfbml: true,
            version: 'v3.3'
        });
    };
    (function (d, s, id) {
        var js, fjs = d.getElementsByTagName(s)[0];
        if (d.getElementById(id)) {
            return;
        }
        js = d.createElement(s);
        js.id = id;
        js.src = "https://connect.facebook.net/en_US/sdk/xfbml.customerchat.js";
        fjs.parentNode.insertBefore(js, fjs);
    }(document, 'script', 'facebook-jssdk'));
    @endif

        @if (auth()->check() && auth()->user()->role_id > 1)
    if ('serviceWorker' in navigator) {
        navigator.serviceWorker.register('{{ static_asset('admin/js/OneSignalSDKWorker.js') }}')
            .then(function (registration) {
                /* console.log('Service Worker registered with scope:', registration.scope); */
            })
            .catch(function (error) {
                /* console.error('Service Worker registration failed:', error); */
            });
    }
        window.OneSignal = window.OneSignal || [];
    OneSignal.push(function () {
        OneSignal.init({
            appId: "{{ setting('onesignal_app_id') }}",
            safari_web_id: "{{ setting('safari_web_id') }}",
            notifyButton: {
                enable: true,
            },
            serviceWorker: {
                path: "{{ static_asset('admin/js/OneSignalSDKWorker.js') }}",
            },
            allowLocalhostAsSecureOrigin: true,

        });
        OneSignal.on('subscriptionChange', function (isSubscribed) {
            if (isSubscribed) {
                OneSignal.getUserId().then(function (userId) {
                    $.ajax({
                        url: '{{ route('onesignal.update-subscription') }}',
                        method: 'POST',
                        data: {
                            player_id: userId,
                            subscribed: 1
                        }
                    });
                });
            }
            else{
                $.ajax({
                    url: '{{ route('onesignal.update-subscription') }}',
                    method: 'POST',
                    data: {
                        subscribed: 0
                    }
                });
            }
        });
    });
    @endif
</script>

@if (setting('custom_footer_script'))
    {!! base64_decode(setting('custom_footer_script')) !!}
@endif
</body>
</html>